/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class TrimFunction
implements Function {
    private static final long serialVersionUID = 7379670108270974597L;

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n = parameterCallback.getParameterCount();
        if (n < 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type = parameterCallback.getType(0);
        Object object = parameterCallback.getValue(0);
        String string = formulaContext.getTypeRegistry().convertToText(type, object);
        if (string == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        boolean bl = true;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isWhitespace(c)) {
                if (bl) continue;
                stringBuffer.append(c);
                bl = true;
                continue;
            }
            stringBuffer.append(c);
            bl = false;
        }
        String string2 = bl ? stringBuffer.substring(0, stringBuffer.length() - 1) : stringBuffer.toString();
        return new TypeValuePair(TextType.TYPE, string2);
    }

    @Override
    public String getCanonicalName() {
        return "TRIM";
    }
}

