/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class MidFunction
implements Function {
    private static final long serialVersionUID = 4190365695032245709L;

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n = parameterCallback.getParameterCount();
        if (n != 3) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Type type = parameterCallback.getType(0);
        Object object = parameterCallback.getValue(0);
        Type type2 = parameterCallback.getType(1);
        Object object2 = parameterCallback.getValue(1);
        Type type3 = parameterCallback.getType(2);
        Object object3 = parameterCallback.getValue(2);
        String string = typeRegistry.convertToText(type, object);
        Number number = typeRegistry.convertToNumber(type2, object2);
        Number number2 = typeRegistry.convertToNumber(type3, object3);
        if (number2.doubleValue() < 0.0 || number.doubleValue() < 1.0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        return new TypeValuePair(TextType.TYPE, MidFunction.process(string, number.intValue(), number2.intValue()));
    }

    public static String process(String string, int n, int n2) {
        int n3 = n - 1;
        if (n3 >= string.length() || n3 < 0) {
            return "";
        }
        if (n2 + n3 > string.length()) {
            n2 = string.length() - n3;
        }
        return string.substring(n3, n3 + n2);
    }

    @Override
    public String getCanonicalName() {
        return "MID";
    }
}

