/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class FindFunction
implements Function {
    private static final long serialVersionUID = -6581390286475368968L;

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n;
        int n2 = parameterCallback.getParameterCount();
        if (n2 < 2 || n2 > 3) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Type type = parameterCallback.getType(0);
        Object object = parameterCallback.getValue(0);
        Type type2 = parameterCallback.getType(1);
        Object object2 = parameterCallback.getValue(1);
        Type type3 = null;
        Object object3 = null;
        if (n2 == 3) {
            type3 = parameterCallback.getType(2);
            object3 = parameterCallback.getValue(2);
            if (type3 == null || object3 == null) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_MISSING_ARGUMENT_VALUE);
            }
        }
        String string = typeRegistry.convertToText(type, object);
        String string2 = typeRegistry.convertToText(type2, object2);
        if (string == null || string2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        int n3 = 0;
        if (type3 != null) {
            Number number = typeRegistry.convertToNumber(type3, object3);
            if (number.intValue() >= 1) {
                n3 = number.intValue() - 1;
            } else {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
        }
        if ((n = string2.indexOf(string, n3)) < 0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_NOT_FOUND_VALUE);
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(n + 1));
    }

    @Override
    public String getCanonicalName() {
        return "FIND";
    }
}

