/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.typing.sequence.NumberSequence;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class SumFunction
implements Function {
    public static final BigDecimal ZERO = new BigDecimal(0);
    private static final long serialVersionUID = -8604838130517819412L;

    @Override
    public String getCanonicalName() {
        return "SUM";
    }

    protected boolean isStrictSequenceNeeded() {
        return true;
    }

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        BigDecimal bigDecimal = ZERO;
        int n = parameterCallback.getParameterCount();
        if (n == 0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        for (int i = 0; i < n; ++i) {
            Type type = parameterCallback.getType(i);
            Object object = parameterCallback.getValue(i);
            NumberSequence numberSequence = typeRegistry.convertToNumberSequence(type, object, this.isStrictSequenceNeeded());
            while (numberSequence.hasNext()) {
                bigDecimal = this.compute(numberSequence.nextNumber(), bigDecimal);
            }
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, bigDecimal);
    }

    private BigDecimal compute(Number number, BigDecimal bigDecimal) {
        if (number == null) {
            return bigDecimal;
        }
        return bigDecimal.add(NumberUtil.getAsBigDecimal(number));
    }
}

