/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class OddFunction
implements Function {
    private static final long serialVersionUID = -7438242687193650125L;

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n = parameterCallback.getParameterCount();
        if (n < 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type = parameterCallback.getType(0);
        Object object = parameterCallback.getValue(0);
        Number number = formulaContext.getTypeRegistry().convertToNumber(type, object);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, OddFunction.compute(number));
    }

    private static BigDecimal compute(Number number) {
        double d = number.doubleValue();
        int n = d < 0.0 ? (int)Math.floor(d) : (int)Math.ceil(d);
        BigDecimal bigDecimal = n == 0 ? (d < 0.0 ? new BigDecimal(-1) : new BigDecimal(1)) : (n % 2 != 0 ? new BigDecimal(n) : (d < 0.0 ? new BigDecimal(n - 1) : new BigDecimal(n + 1)));
        return bigDecimal;
    }

    @Override
    public String getCanonicalName() {
        return "ODD";
    }
}

