/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.typing.sequence.NumberSequence;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class MaxFunction
implements Function {
    private static final BigDecimal ZERO = new BigDecimal(0);
    private static final long serialVersionUID = -836670420852371100L;

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n = parameterCallback.getParameterCount();
        if (n == 0) {
            return new TypeValuePair(NumberType.GENERIC_NUMBER, ZERO);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        BigDecimal bigDecimal = null;
        for (int i = 0; i < n; ++i) {
            Type type = parameterCallback.getType(i);
            Object object = parameterCallback.getValue(i);
            NumberSequence numberSequence = typeRegistry.convertToNumberSequence(type, object, this.isStrictSequenceNeeded());
            while (numberSequence.hasNext()) {
                LValue lValue = numberSequence.nextRawValue();
                if (lValue == null) {
                    throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
                }
                TypeValuePair typeValuePair = lValue.evaluate();
                Number number = typeRegistry.convertToNumber(typeValuePair.getType(), typeValuePair.getValue());
                BigDecimal bigDecimal2 = NumberUtil.getAsBigDecimal(number);
                if (bigDecimal == null) {
                    bigDecimal = bigDecimal2;
                    continue;
                }
                if (bigDecimal.compareTo(bigDecimal2) != -1) continue;
                bigDecimal = bigDecimal2;
            }
        }
        if (bigDecimal == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, bigDecimal);
    }

    protected boolean isStrictSequenceNeeded() {
        return true;
    }

    @Override
    public String getCanonicalName() {
        return "MAX";
    }
}

