/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class IsOddFunction
implements Function {
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final long serialVersionUID = 4967067216812927973L;

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n = parameterCallback.getParameterCount();
        if (n < 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type = parameterCallback.getType(0);
        Object object = parameterCallback.getValue(0);
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Number number = typeRegistry.convertToNumber(type, object);
        if (number == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        int n2 = number.intValue();
        if (n2 < 0) {
            n2 *= -1;
        }
        if (n2 % 2 == 1) {
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }

    @Override
    public String getCanonicalName() {
        return "ISODD";
    }
}

