/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.ErrorType;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class IsErrFunction
implements Function {
    private static final Log logger = LogFactory.getLog(IsErrFunction.class);
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final long serialVersionUID = 6749192734608313367L;

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        if (parameterCallback.getParameterCount() != 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        try {
            Type type = parameterCallback.getType(0);
            Object object = parameterCallback.getValue(0);
            if (ErrorType.TYPE.equals(type) && object instanceof ErrorValue) {
                logger.warn((Object)"Passing errors around is deprecated. Throw exceptions instead.");
                ErrorValue errorValue = (ErrorValue)object;
                if (errorValue.getErrorCode() == 522) {
                    return RETURN_FALSE;
                }
                return RETURN_TRUE;
            }
        }
        catch (EvaluationException evaluationException) {
            if (evaluationException.getErrorValue().getErrorCode() == 522) {
                return RETURN_FALSE;
            }
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }

    @Override
    public String getCanonicalName() {
        return "ISERR";
    }
}

