/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.typing.sequence.NumberSequence;

public class CountFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "COUNT";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n = parameterCallback.getParameterCount();
        if (n == 0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                Type type = parameterCallback.getType(i);
                Object object = parameterCallback.getValue(i);
                NumberSequence numberSequence = formulaContext.getTypeRegistry().convertToNumberSequence(type, object, true);
                while (numberSequence.hasNext()) {
                    numberSequence.next();
                    ++n2;
                }
                continue;
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(n2));
    }
}

