/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class CountBlankFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "COUNTBLANK";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n = parameterCallback.getParameterCount();
        if (n != 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        int n2 = 0;
        Object object = parameterCallback.getValue(0);
        Type type = parameterCallback.getType(0);
        LValue lValue = parameterCallback.getRaw(0);
        if (lValue instanceof ContextLookup && object != null) {
            try {
                Sequence sequence = formulaContext.getTypeRegistry().convertToSequence(type, object);
                while (sequence.hasNext()) {
                    Object object2 = sequence.next();
                    if (object2 != null) continue;
                    ++n2;
                }
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(n2));
    }
}

