/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.DateUtil;

public class WeekDayFunction
implements Function {
    private static final long serialVersionUID = -825027235225096201L;

    @Override
    public String getCanonicalName() {
        return "WEEKDAY";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        Serializable serializable;
        if (parameterCallback.getParameterCount() > 2) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Date date = typeRegistry.convertToDate(parameterCallback.getType(0), parameterCallback.getValue(0));
        int n = 1;
        if (parameterCallback.getParameterCount() == 2) {
            serializable = typeRegistry.convertToNumber(parameterCallback.getType(1), parameterCallback.getValue(1));
            if (serializable == null) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            n = ((Number)serializable).intValue();
            if (n < 1 || n > 3) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
        }
        if (date == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        serializable = DateUtil.createCalendar(date, formulaContext.getLocalizationContext());
        int n2 = ((Calendar)serializable).get(7);
        int n3 = this.convertType(n2, n);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal((double)n3));
    }

    public int convertType(int n, int n2) {
        if (n2 == 1) {
            return n;
        }
        if (n2 == 2) {
            int n3 = (n + 6) % 8;
            if (n3 == 7) {
                return n3;
            }
            return n3 + 1;
        }
        return (n + 5) % 7;
    }
}

