/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.sql.Time;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;
import org.pentaho.reporting.libraries.formula.util.DateUtil;

public class TimeFunction
implements Function {
    private static final long serialVersionUID = -9175775325047486483L;

    @Override
    public String getCanonicalName() {
        return "TIME";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        Number number;
        Number number2;
        Number number3;
        if (parameterCallback.getParameterCount() != 3) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        try {
            TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
            number3 = typeRegistry.convertToNumber(parameterCallback.getType(0), parameterCallback.getValue(0));
            number2 = typeRegistry.convertToNumber(parameterCallback.getType(1), parameterCallback.getValue(1));
            number = typeRegistry.convertToNumber(parameterCallback.getType(2), parameterCallback.getValue(2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (number3 == null || number2 == null || number == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        int n = number3.intValue();
        int n2 = number2.intValue();
        int n3 = number.intValue();
        LocalizationContext localizationContext = formulaContext.getLocalizationContext();
        Time time = DateUtil.createTime(n, n2, n3, localizationContext);
        return new TypeValuePair(DateTimeType.TIME_TYPE, time);
    }
}

