/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class DaysFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "DAYS";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        if (parameterCallback.getParameterCount() != 2) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Date date = typeRegistry.convertToDate(parameterCallback.getType(0), parameterCallback.getValue(0));
        Date date2 = typeRegistry.convertToDate(parameterCallback.getType(1), parameterCallback.getValue(1));
        if (date == null || date2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        LocalizationContext localizationContext = formulaContext.getLocalizationContext();
        TimeZone timeZone = localizationContext.getTimeZone();
        Locale locale = localizationContext.getLocale();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone, locale);
        gregorianCalendar.setTime(date);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(timeZone, locale);
        gregorianCalendar2.setTime(date2);
        int n = gregorianCalendar.get(6);
        int n2 = gregorianCalendar2.get(6);
        int n3 = gregorianCalendar.get(1);
        int n4 = gregorianCalendar2.get(1);
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar(timeZone, locale);
        int n5 = n2 - n;
        int n6 = Math.max(n3, n4);
        for (int i = Math.min(n3, n4); i < n6; ++i) {
            gregorianCalendar3.set(1, i);
            n5 += gregorianCalendar3.getActualMaximum(6);
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal((double)n5));
    }
}

