/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.util.Date;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;

public class DateValueFunction
implements Function {
    private static final long serialVersionUID = -906531902889630172L;

    @Override
    public String getCanonicalName() {
        return "DATEVALUE";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        if (parameterCallback.getParameterCount() != 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Type type = parameterCallback.getType(0);
        Object object = parameterCallback.getValue(0);
        Date date = typeRegistry.convertToDate(type, object);
        return new TypeValuePair(DateTimeType.DATE_TYPE, date);
    }
}

