/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.typing.Type;

public class DefaultLocalizationContext
implements LocalizationContext,
Serializable {
    private static final String CONFIG_TIMEZONE_KEY = "org.pentaho.reporting.libraries.formula.timezone";
    private static final String CONFIG_LOCALE_KEY = "org.pentaho.reporting.libraries.formula.locale";
    private static final String CONFIG_DATEFORMAT_KEY = "org.pentaho.reporting.libraries.formula.dateformat.";
    private ArrayList dateFormats = new ArrayList();
    private ArrayList datetimeFormats = new ArrayList();
    private ArrayList timeFormats = new ArrayList();
    private Locale locale;
    private TimeZone timeZone;

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public ResourceBundle getBundle(String string) {
        return ResourceBundle.getBundle(string, this.getLocale());
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public List getDateFormats(Type type) {
        if (type.isFlagSet("type.date")) {
            return (List)this.dateFormats.clone();
        }
        if (type.isFlagSet("type.datetime")) {
            return (List)this.datetimeFormats.clone();
        }
        if (type.isFlagSet("type.time")) {
            return (List)this.timeFormats.clone();
        }
        return Collections.EMPTY_LIST;
    }

    private String[] createLocale(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        String[] stringArray = new String[]{stringTokenizer.hasMoreElements() ? stringTokenizer.nextToken() : "", stringTokenizer.hasMoreElements() ? stringTokenizer.nextToken() : "", stringTokenizer.hasMoreElements() ? stringTokenizer.nextToken() : ""};
        return stringArray;
    }

    private String[] createFormatSpec(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() == 2) {
            String[] stringArray = new String[]{stringTokenizer.nextToken(), stringTokenizer.nextToken()};
            return stringArray;
        }
        if (string.length() > 0) {
            String[] stringArray = new String[]{stringTokenizer.nextToken(), ""};
            return stringArray;
        }
        return null;
    }

    public void initialize(Configuration configuration) {
        this.initialize(configuration, null, null);
    }

    public void initialize(Configuration configuration, Locale locale, TimeZone timeZone) {
        Object object;
        if (configuration == null) {
            throw new NullPointerException();
        }
        if (locale == null) {
            object = configuration.getConfigProperty(CONFIG_LOCALE_KEY, Locale.getDefault().toString());
            String[] stringArray = this.createLocale((String)object);
            this.locale = new Locale(stringArray[0], stringArray[1], stringArray[2]);
        } else {
            this.locale = locale;
        }
        if (timeZone == null) {
            object = configuration.getConfigProperty(CONFIG_TIMEZONE_KEY, TimeZone.getDefault().getID());
            this.timeZone = TimeZone.getTimeZone((String)object);
        } else {
            this.timeZone = TimeZone.getDefault();
        }
        object = this.getLocale();
        this.datetimeFormats.add(DateFormat.getDateTimeInstance(0, 0, (Locale)object));
        this.dateFormats.add(DateFormat.getDateInstance(0, (Locale)object));
        this.timeFormats.add(DateFormat.getTimeInstance(0, (Locale)object));
        this.datetimeFormats.add(DateFormat.getDateTimeInstance(1, 1, (Locale)object));
        this.dateFormats.add(DateFormat.getDateInstance(1, (Locale)object));
        this.timeFormats.add(DateFormat.getTimeInstance(1, (Locale)object));
        this.datetimeFormats.add(DateFormat.getDateTimeInstance(2, 2, (Locale)object));
        this.dateFormats.add(DateFormat.getDateInstance(2, (Locale)object));
        this.timeFormats.add(DateFormat.getTimeInstance(2, (Locale)object));
        this.datetimeFormats.add(DateFormat.getDateTimeInstance(3, 3, (Locale)object));
        this.dateFormats.add(DateFormat.getDateInstance(3, (Locale)object));
        this.timeFormats.add(DateFormat.getTimeInstance(3, (Locale)object));
        this.datetimeFormats.add(DateFormat.getDateTimeInstance(3, 3, (Locale)object));
        this.dateFormats.add(DateFormat.getDateInstance(3, (Locale)object));
        this.timeFormats.add(DateFormat.getTimeInstance(3, (Locale)object));
        this.datetimeFormats.add(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.US));
        this.dateFormats.add(new SimpleDateFormat("yyyy-MM-dd", Locale.US));
        this.timeFormats.add(new SimpleDateFormat("hh:mm:ss", Locale.US));
        this.timeFormats.add(new SimpleDateFormat("hh:mm", Locale.US));
    }
}

