/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.serializer.methods;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.pentaho.reporting.libraries.serializer.SerializeMethod;

public class PageFormatSerializer
implements SerializeMethod {
    @Override
    public void writeObject(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        PageFormat pageFormat = (PageFormat)object;
        objectOutputStream.writeObject(this.resolvePageFormat(pageFormat));
    }

    @Override
    public Object readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object[] objectArray = (Object[])objectInputStream.readObject();
        return this.createPageFormat(objectArray);
    }

    @Override
    public Class getObjectClass() {
        return PageFormat.class;
    }

    private Object[] resolvePageFormat(PageFormat pageFormat) {
        Integer n = new Integer(pageFormat.getOrientation());
        Paper paper = pageFormat.getPaper();
        float[] fArray = new float[]{(float)paper.getWidth(), (float)paper.getHeight()};
        float[] fArray2 = new float[]{(float)paper.getImageableX(), (float)paper.getImageableY(), (float)paper.getImageableWidth(), (float)paper.getImageableHeight()};
        return new Object[]{n, fArray, fArray2};
    }

    private PageFormat createPageFormat(Object[] objectArray) {
        Integer n = (Integer)objectArray[0];
        float[] fArray = (float[])objectArray[1];
        float[] fArray2 = (float[])objectArray[2];
        Paper paper = new Paper();
        paper.setSize(fArray[0], fArray[1]);
        paper.setImageableArea(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
        PageFormat pageFormat = new PageFormat();
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(n);
        return pageFormat;
    }
}

