/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.ucb.InteractiveAugmentedIOException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.URL;
import com.sun.star.util.XMacroExpander;
import com.sun.star.util.XURLTransformer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class utils {
    public static String getFullTestDocName(String sDocName) {
        String docpth = System.getProperty("DOCPTH");
        if (docpth.endsWith("\\") || docpth.endsWith("/")) {
            docpth = docpth.substring(0, docpth.length() - 1);
        }
        System.out.println("docpth:" + docpth);
        String pthSep = System.getProperty("file.separator");
        if (docpth.equals("unkown")) {
            String tDoc;
            File srcR;
            String[] list;
            System.out.println("try to get tDoc from $SRC_ROOT/qadevOOo");
            String srcRoot = System.getProperty("SRC_ROOT");
            if (srcRoot != null && (list = (srcR = new File(srcRoot)).list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("qadevOOo");
                }
            }))[0] != null && new File(tDoc = srcRoot.concat(pthSep).concat(list[0]).concat(pthSep).concat("testdocs")).exists()) {
                docpth = tDoc;
            }
        }
        if (docpth.startsWith("http:")) {
            return docpth + "/" + sDocName;
        }
        String testdocPth = "";
        if (docpth.equals("unkown")) {
            System.out.println("try to get tDoc from OBJDSCS");
            String objdscPth = System.getProperty("OBJDSCS");
            if (objdscPth != null) {
                int i = objdscPth.indexOf("objdsc");
                String arcPth = objdscPth.substring(0, i - 1);
                testdocPth = arcPth + pthSep + "doc" + pthSep + "java" + pthSep + "testdocs" + pthSep + sDocName;
            }
        } else {
            testdocPth = docpth + pthSep + sDocName;
        }
        return testdocPth;
    }

    public static String getFullTestURL(String sDocName) {
        File aFile;
        String fullDocPath = utils.getFullTestDocName(sDocName);
        if (fullDocPath.startsWith("http:")) {
            return fullDocPath;
        }
        if (fullDocPath.startsWith("file:")) {
            return fullDocPath;
        }
        String prefix = null;
        if (fullDocPath.startsWith("\\\\")) {
            prefix = "file:";
        }
        fullDocPath = fullDocPath.replace('\\', '/');
        if (prefix == null) {
            prefix = fullDocPath.startsWith("//") ? "file:/" : (fullDocPath.startsWith("/") ? "file://" : "file:///");
        }
        if (!fullDocPath.endsWith("/") && (aFile = new File(fullDocPath)).isDirectory()) {
            fullDocPath = fullDocPath + "/";
        }
        String fulldocURL = prefix + fullDocPath;
        return fulldocURL;
    }

    public static String getFullURL(String sDocName) {
        File aFile;
        String fullDocPath = sDocName;
        if ((fullDocPath = fullDocPath.replace('\\', '/')).startsWith("http:")) {
            return fullDocPath;
        }
        if (fullDocPath.startsWith("ftp:")) {
            return fullDocPath;
        }
        String prefix = "";
        if (!fullDocPath.startsWith("file:///")) {
            prefix = fullDocPath.startsWith("//") ? "file:" : (fullDocPath.startsWith("/") ? "file://" : "file:///");
        }
        if (!fullDocPath.endsWith("/") && (aFile = new File(fullDocPath)).isDirectory()) {
            fullDocPath = fullDocPath + "/";
        }
        String fulldocURL = prefix + fullDocPath;
        return fulldocURL;
    }

    public static void make_Directories(String first, String path) {
        String already_done = null;
        String fs = System.getProperty("file.separator");
        StringTokenizer path_tokenizer = new StringTokenizer(path, fs, false);
        already_done = first;
        while (path_tokenizer.hasMoreTokens()) {
            String part = path_tokenizer.nextToken();
            File new_dir = new File(already_done + File.separatorChar + part);
            already_done = new_dir.toString();
            new_dir.mkdirs();
        }
    }

    public static String getVersion(String aFile, String aPlatform, String aTestbase) {
        if (aFile == null || aPlatform == null || aTestbase == null) {
            return "/";
        }
        File the_file = new File(aFile);
        try {
            RandomAccessFile raf = new RandomAccessFile(the_file, "r");
            String res = "";
            while (!res.equals("[" + aTestbase.toUpperCase() + "]")) {
                res = raf.readLine();
            }
            res = "=/";
            while (!res.startsWith(aPlatform) || res.startsWith("[")) {
                res = raf.readLine();
            }
            raf.close();
            if (res.startsWith("[")) {
                res = "/";
            }
            return res.substring(res.indexOf("=") + 1);
        }
        catch (Exception e) {
            System.out.println("Couldn't find version");
            return "/";
        }
    }

    public static String getOfficeUserPath(XMultiServiceFactory msf) {
        int index;
        String userPath = null;
        try {
            userPath = utils.getOfficeSettingsValue(msf, "UserConfig");
        }
        catch (Exception e) {
            System.out.println("Couldn't get Office User Path");
            e.printStackTrace();
        }
        if (userPath.charAt(userPath.length() - 1) == '/') {
            userPath = userPath.substring(0, userPath.length() - 1);
        }
        if ((index = userPath.lastIndexOf(47)) != -1) {
            userPath = userPath.substring(0, index);
        }
        return userPath;
    }

    public static String getOfficeSettingsValue(XMultiServiceFactory msf, String setting) {
        String settingPath = null;
        try {
            Object settings = msf.createInstance("com.sun.star.comp.framework.PathSettings");
            XPropertySet pthSettings = null;
            try {
                pthSettings = (XPropertySet)AnyConverter.toObject((Type)new Type(XPropertySet.class), (Object)settings);
            }
            catch (IllegalArgumentException iae) {
                System.out.println("### couldn't get Office Settings");
            }
            settingPath = (String)pthSettings.getPropertyValue(setting);
        }
        catch (Exception e) {
            System.out.println("Couldn't get stting value for " + setting);
            e.printStackTrace();
        }
        return settingPath;
    }

    public static void setOfficeSettingsValue(XMultiServiceFactory msf, String setting, String value) {
        Object settingPath = null;
        try {
            Object settings = msf.createInstance("com.sun.star.comp.framework.PathSettings");
            XPropertySet pthSettings = null;
            try {
                pthSettings = (XPropertySet)AnyConverter.toObject((Type)new Type(XPropertySet.class), (Object)settings);
            }
            catch (IllegalArgumentException iae) {
                System.out.println("### couldn't get Office Settings");
            }
            pthSettings.setPropertyValue(setting, value);
        }
        catch (Exception e) {
            System.out.println("Couldn't set '" + setting + "' to value '" + value + "'");
            e.printStackTrace();
        }
    }

    public static String getUsersTempDir() {
        String tempDir = System.getProperty("my.temp");
        if (tempDir == null && (tempDir = System.getProperty("my.tmp")) == null) {
            tempDir = System.getProperty("java.io.tmpdir");
        }
        if (tempDir.endsWith(System.getProperty("file.separator"))) {
            tempDir = tempDir.substring(0, tempDir.length() - 1);
        }
        return tempDir;
    }

    public static String getOfficeTemp(XMultiServiceFactory msf) {
        String tmpDir = utils.getUsersTempDir();
        try {
            String tmp = utils.getOfficeSettingsValue(msf, "Temp");
            if (!tmp.endsWith(System.getProperty("file.separator"))) {
                tmp = tmp + System.getProperty("file.separator");
            }
            tmpDir = utils.getFullURL(tmp);
        }
        catch (Exception e) {
            System.out.println("Couldn't get Office TEMP");
            e.printStackTrace();
        }
        return tmpDir;
    }

    public static String getOfficeTempDir(XMultiServiceFactory msf) {
        boolean lastCharSet;
        String dir = utils.getOfficeTemp(msf);
        int idx = dir.indexOf("file:///");
        if (idx < 0) {
            return dir;
        }
        dir = dir.substring("file:///".length());
        idx = dir.indexOf(":");
        boolean bl = lastCharSet = dir.endsWith("/") || dir.endsWith("\\");
        if (idx < 0) {
            dir = "/" + dir;
            dir = dir + (lastCharSet ? "" : "/");
        } else {
            dir = dir + (lastCharSet ? "" : "\\");
        }
        return dir;
    }

    public static String getOfficeTempDirSys(XMultiServiceFactory msf) {
        String dir = utils.getOfficeTemp(msf);
        String sysDir = "";
        int idx = dir.indexOf("file://");
        sysDir = idx < 0 ? dir : dir.substring("file://".length());
        if (sysDir.charAt(sysDir.length() - 1) != '/') {
            sysDir = sysDir + "/";
        }
        if (sysDir.indexOf(":") != -1) {
            sysDir = sysDir.substring(1);
            sysDir = sysDir.replace('/', '\\');
        }
        return sysDir;
    }

    public static String getSystemURL(String fileURL) {
        String sysDir = "";
        int idx = fileURL.indexOf("file://");
        sysDir = idx < 0 ? fileURL : fileURL.substring("file://".length());
        if (sysDir.indexOf(":") != -1) {
            sysDir = sysDir.substring(1);
            sysDir = sysDir.replace('/', '\\');
        }
        return sysDir;
    }

    public static boolean fileExists(XMultiServiceFactory msf, String fileURL) {
        boolean exists = false;
        try {
            Object fileacc = msf.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
            XSimpleFileAccess simpleAccess = UnoRuntime.queryInterface(XSimpleFileAccess.class, fileacc);
            if (simpleAccess.exists(fileURL)) {
                exists = true;
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't access file '" + fileURL + "'");
            e.printStackTrace();
            exists = false;
        }
        return exists;
    }

    public static boolean deleteFile(XMultiServiceFactory xMsf, String fileURL) {
        boolean delete = true;
        try {
            Object fileacc = xMsf.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
            XSimpleFileAccess simpleAccess = UnoRuntime.queryInterface(XSimpleFileAccess.class, fileacc);
            if (simpleAccess.exists(fileURL)) {
                simpleAccess.kill(fileURL);
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't delete file '" + fileURL + "'");
            e.printStackTrace();
            delete = false;
        }
        return delete;
    }

    public static boolean copyFile(XMultiServiceFactory xMsf, String source, String destinaion) {
        boolean res = false;
        try {
            Object fileacc = xMsf.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
            XSimpleFileAccess simpleAccess = UnoRuntime.queryInterface(XSimpleFileAccess.class, fileacc);
            if (!simpleAccess.exists(destinaion)) {
                simpleAccess.copy(source, destinaion);
            }
            res = true;
        }
        catch (Exception e) {
            System.out.println("Couldn't copy file '" + source + "' -> '" + destinaion + "'");
            e.printStackTrace();
            res = false;
        }
        return res;
    }

    public static boolean overwriteFile(XMultiServiceFactory xMsf, String oldF, String newF) {
        boolean res = false;
        try {
            Object fileacc = xMsf.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
            XSimpleFileAccess simpleAccess = UnoRuntime.queryInterface(XSimpleFileAccess.class, fileacc);
            if (simpleAccess.exists(newF)) {
                simpleAccess.kill(newF);
            }
            simpleAccess.copy(oldF, newF);
            res = true;
        }
        catch (InteractiveAugmentedIOException e) {
            return false;
        }
        catch (com.sun.star.uno.Exception e) {
            System.out.println("Couldn't create a service.");
            e.printStackTrace();
        }
        return res;
    }

    public static boolean hasPropertyByName(XPropertySet props, String aName) {
        Property[] list = props.getPropertySetInfo().getProperties();
        boolean res = false;
        for (int i = 0; i < list.length; ++i) {
            String the_name = list[i].Name;
            if (!aName.equals(the_name)) continue;
            res = true;
        }
        return res;
    }

    public static String getImplName(Object aObject) {
        String res = "Error getting Implementation name";
        try {
            XServiceInfo xSI = UnoRuntime.queryInterface(XServiceInfo.class, aObject);
            res = xSI.getImplementationName();
        }
        catch (Exception e) {
            res = "Error getting Implementation name ( " + e + " )";
        }
        return res;
    }

    public static boolean isVoid(Object aObject) {
        if (aObject instanceof Any) {
            Any oAny = (Any)aObject;
            return oAny.getType().getTypeName().equals("void");
        }
        return false;
    }

    public static String replacePart(String all, String toReplace, String replacement) {
        return utils.replaceAll13(all, toReplace, replacement);
    }

    public static int getNextFreePort(int startPort) {
        if (startPort < 1024) {
            startPort = 10000;
        }
        for (int port = startPort; port < 65536; ++port) {
            System.out.println("Scan port " + port);
            try {
                ServerSocket sSock = new ServerSocket(port);
                sSock.close();
            }
            catch (IOException e) {
                System.out.println(" -> server: occupied port " + port);
                continue;
            }
            try {
                Socket sock = new Socket("localhost", port);
                System.out.println(" -> socket: occupied port: " + port);
                continue;
            }
            catch (IOException e) {
                System.out.println(" -> free port");
                return port;
            }
        }
        return 65535;
    }

    public static URL parseURL(XMultiServiceFactory xMSF, String url) {
        URL[] rUrl = new URL[]{new URL()};
        rUrl[0].Complete = url;
        XURLTransformer xTrans = null;
        try {
            Object inst = xMSF.createInstance("com.sun.star.util.URLTransformer");
            xTrans = UnoRuntime.queryInterface(XURLTransformer.class, inst);
        }
        catch (com.sun.star.uno.Exception e) {
            // empty catch block
        }
        xTrans.parseStrict(rUrl);
        return rUrl[0];
    }

    public static String getOfficeURL(XMultiServiceFactory msf) {
        try {
            Object settings = msf.createInstance("com.sun.star.util.PathSettings");
            XPropertySet settingProps = UnoRuntime.queryInterface(XPropertySet.class, settings);
            String path = (String)settingProps.getPropertyValue("Module");
            return path;
        }
        catch (Exception e) {
            System.out.println("Couldn't get Office Settings ");
            e.printStackTrace();
            return null;
        }
    }

    public static String getOfficeBinPath(XMultiServiceFactory msf) {
        String sysBinDir = "";
        try {
            sysBinDir = utils.getSystemURL(utils.expandMacro(msf, "$SYSBINDIR"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sysBinDir;
    }

    public static String[] getFilteredPropertyNames(XPropertySet props, short includePropertyAttribute, short excludePropertyAttribute) {
        Property[] the_props = props.getPropertySetInfo().getProperties();
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < the_props.length; ++i) {
            boolean include;
            boolean exclude = (the_props[i].Attributes & excludePropertyAttribute) != 0;
            boolean bl = include = includePropertyAttribute == 0 || (the_props[i].Attributes & includePropertyAttribute) != 0;
            if (!include || exclude) continue;
            l.add(the_props[i].Name);
        }
        Collections.sort(l);
        String[] names = new String[l.size()];
        names = l.toArray(names);
        return names;
    }

    public static void shortWait(int milliseconds) {
        try {
            Thread.currentThread();
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }

    public static String validateAppExecutionCommand(String appExecCommand, String os) {
        String errorMessage = "OK";
        appExecCommand = utils.replaceAll13(appExecCommand, "\"", "");
        appExecCommand = utils.replaceAll13(appExecCommand, "'", "");
        StringTokenizer commandTokens = new StringTokenizer(appExecCommand, " \t");
        String officeExecutable = "";
        String officeExecCommand = "soffice";
        int index = -1;
        while (commandTokens.hasMoreTokens() && index == -1) {
            officeExecutable = officeExecutable + commandTokens.nextToken() + " ";
            index = officeExecutable.indexOf(officeExecCommand);
        }
        if (index == -1) {
            errorMessage = "Error: Your 'AppExecutionCommand' parameter does not contain '" + officeExecCommand + "'.";
        } else {
            String officePath = (officeExecutable = officeExecutable.trim()).substring(0, index);
            File f = new File(officePath);
            if (!f.exists() || !f.isDirectory()) {
                errorMessage = "Error: Your 'AppExecutionCommand' parameter does not point to a valid system directory: " + officePath;
            } else {
                f = new File(officeExecutable);
                if (!f.exists() || !f.isFile()) {
                    f = new File(officeExecutable + ".exe");
                }
                if (!f.exists() || !f.isFile()) {
                    errorMessage = "Error: Your 'AppExecutionCommand' parameter does not point to a valid office installation.";
                } else {
                    boolean gotNoAccept = true;
                    while (commandTokens.hasMoreElements()) {
                        String officeParam = commandTokens.nextToken();
                        if (officeParam.indexOf("-accept=") == -1) continue;
                        gotNoAccept = false;
                        errorMessage = utils.validateConnectString(officeParam, true);
                    }
                    if (gotNoAccept) {
                        errorMessage = "Error: Your 'AppExecutionCommand' parameter does not contain a '-accept' parameter for connecting the office.";
                    }
                }
            }
        }
        return errorMessage;
    }

    public static String validateConnectString(String connectString, boolean checkAppExecutionCommand) {
        String acceptPrefix = "";
        if (checkAppExecutionCommand) {
            acceptPrefix = "-accept=";
        }
        String errorMessage = "OK";
        if (connectString.indexOf("socket") != -1) {
            if (connectString.indexOf(acceptPrefix + "socket,host=") == -1 || connectString.indexOf("port=") == -1) {
                errorMessage = checkAppExecutionCommand ? "Error: The '-accept' parameter contains a syntax error: It should be like: '-accept=socket,host=localhost,port=8100;urp;" : "Error: The 'ConnectionString' parameter contains a syntax error: It should be like: 'socket,host=localhost,port=8100'";
            }
        } else if (connectString.indexOf("pipe") != -1) {
            if (connectString.indexOf(acceptPrefix + "pipe,name=") == -1) {
                errorMessage = checkAppExecutionCommand ? "Error: The '-accept' parameter contains a syntax error: It should be like: '-accept=pipe,name=myuniquename;urp;'" : "Error: The 'ConnectionString' parameter contains a syntax error: It should be like: 'pipe,name=myuniquename'";
            }
        } else {
            errorMessage = checkAppExecutionCommand ? "Warning: The '-accept' parameter contains an unknown connection method." : "Warning: The 'ConnectionString' parameter contains an unknown connection method.";
        }
        return errorMessage;
    }

    public static String replaceAll13(String originalString, String searchString, String replaceString) {
        StringBuffer changeStringBuffer = new StringBuffer(originalString);
        int searchLength = searchString.length();
        int replaceLength = replaceString.length();
        int index = originalString.indexOf(searchString);
        while (index != -1) {
            changeStringBuffer = changeStringBuffer.replace(index, index + searchLength, replaceString);
            originalString = changeStringBuffer.toString();
            index = originalString.indexOf(searchString, index + replaceLength);
        }
        return originalString;
    }

    public static String expandMacro(XMultiServiceFactory xMSF, String expand) throws Exception {
        try {
            XPropertySet xPS = UnoRuntime.queryInterface(XPropertySet.class, (Object)xMSF);
            XComponentContext xContext = UnoRuntime.queryInterface(XComponentContext.class, xPS.getPropertyValue("DefaultContext"));
            XMacroExpander xME = UnoRuntime.queryInterface(XMacroExpander.class, xContext.getValueByName("/singletons/com.sun.star.util.theMacroExpander"));
            return xME.expandMacros(expand);
        }
        catch (Exception e) {
            throw new Exception("could not expand macro: " + e.toString(), e);
        }
    }

    public static String getOfficeOS(XMultiServiceFactory xMSF) {
        String platform = "unkown";
        try {
            String theOS = utils.expandMacro(xMSF, "$_OS");
            if (theOS.equals("Windows")) {
                platform = "wntmsci";
            } else if (theOS.equals("Linux")) {
                platform = "unxlngi";
            } else if (theOS.equals("Solaris")) {
                String theArch = utils.expandMacro(xMSF, "$_ARCH");
                if (theArch.equals("SPARC")) {
                    platform = "unxsols";
                } else if (theArch.equals("x86")) {
                    platform = "unxsoli";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return platform;
    }

    public static void dispatchURL(XMultiServiceFactory xMSF, XComponent xDoc, String URL2) throws Exception {
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)xDoc);
        XController xCont = aModel.getCurrentController();
        utils.dispatchURL(xMSF, xCont, URL2);
    }

    public static void dispatchURL(XMultiServiceFactory xMSF, XController xCont, String URL2) throws Exception {
        try {
            XDispatchProvider xDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xCont);
            XURLTransformer xParser = UnoRuntime.queryInterface(XURLTransformer.class, xMSF.createInstance("com.sun.star.util.URLTransformer"));
            URL[] aParseURL = new URL[]{new URL()};
            aParseURL[0].Complete = URL2;
            xParser.parseStrict(aParseURL);
            URL aURL = aParseURL[0];
            XDispatch xDispatcher = xDispProv.queryDispatch(aURL, "", 0);
            xDispatcher.dispatch(aURL, null);
            utils.shortWait(3000);
        }
        catch (Exception e) {
            throw new Exception("ERROR: could not dispatch URL '" + URL2 + "': " + e.toString());
        }
    }

    public static String getDateTime() {
        GregorianCalendar cal = new GregorianCalendar();
        DecimalFormat dfmt = new DecimalFormat("00");
        String dateTime = dfmt.format(cal.get(5)) + "." + dfmt.format(cal.get(2) + 1) + "." + dfmt.format(cal.get(1)) + " - " + dfmt.format(cal.get(11)) + ":" + dfmt.format(cal.get(12)) + ":" + dfmt.format(cal.get(13)) + "," + dfmt.format(cal.get(14));
        return "[" + dateTime + "]";
    }
}

