/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNamed;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import util.DesktopTools;
import util.utils;

public class WriterTools {
    public static XTextDocument createTextDoc(XMultiServiceFactory xMSF) {
        PropertyValue[] Args = new PropertyValue[]{};
        XComponent comp = DesktopTools.openNewDoc(xMSF, "swriter", Args);
        XTextDocument WriterDoc = UnoRuntime.queryInterface(XTextDocument.class, (Object)comp);
        return WriterDoc;
    }

    public static XTextDocument loadTextDoc(XMultiServiceFactory xMSF, String url) {
        PropertyValue[] Args = new PropertyValue[]{};
        XTextDocument WriterDoc = WriterTools.loadTextDoc(xMSF, url, Args);
        return WriterDoc;
    }

    public static XTextDocument loadTextDoc(XMultiServiceFactory xMSF, String url, PropertyValue[] Args) {
        XComponent comp = DesktopTools.loadDoc(xMSF, url, Args);
        XTextDocument WriterDoc = UnoRuntime.queryInterface(XTextDocument.class, (Object)comp);
        return WriterDoc;
    }

    public static XDrawPage getDrawPage(XTextDocument aDoc) {
        XDrawPage oDP = null;
        try {
            XDrawPageSupplier oDPS = UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)aDoc);
            oDP = oDPS.getDrawPage();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't get drawpage");
        }
        return oDP;
    }

    public static void insertTextGraphic(XTextDocument aDoc, XMultiServiceFactory xMSF, int hpos, int vpos, int width, int height, String pic, String name) {
        try {
            XInterface oGObject = (XInterface)xMSF.createInstance("com.sun.star.text.GraphicObject");
            XText the_text = aDoc.getText();
            XTextCursor the_cursor = the_text.createTextCursor();
            XTextContent the_content = UnoRuntime.queryInterface(XTextContent.class, (Object)oGObject);
            the_text.insertTextContent(the_cursor, the_content, true);
            XPropertySet oProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)oGObject);
            String fullURL = utils.getFullTestURL(pic);
            oProps.setPropertyValue("GraphicURL", fullURL);
            oProps.setPropertyValue("HoriOrientPosition", new Integer(hpos));
            oProps.setPropertyValue("VertOrientPosition", new Integer(vpos));
            oProps.setPropertyValue("Width", new Integer(width));
            oProps.setPropertyValue("Height", new Integer(height));
            XNamed the_name = UnoRuntime.queryInterface(XNamed.class, (Object)oGObject);
            the_name.setName(name);
        }
        catch (Exception ex) {
            System.out.println("Exception while insertin TextGraphic");
            ex.printStackTrace();
        }
    }
}

