/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Enum;
import com.sun.star.uno.Type;
import com.sun.star.uno.XInterface;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import util.utils;

public class ValueComparer {
    public static boolean equalValue(Object first, Object second) {
        if (first instanceof Any) {
            try {
                first = AnyConverter.toObject((Type)((Any)first).getType(), (Object)first);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        if (second instanceof Any) {
            try {
                second = AnyConverter.toObject((Type)((Any)second).getType(), (Object)second);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        boolean eq = false;
        try {
            eq = first == null || second == null ? first == second : (utils.isVoid(first) && utils.isVoid(second) ? true : (utils.isVoid(first) || utils.isVoid(second) ? first == second : ValueComparer.compareObjects(first, second)));
        }
        catch (Exception e) {
            System.out.println("Exception occured while comparing Objects");
            e.printStackTrace();
        }
        return eq;
    }

    static boolean compareArrayOfPropertyValue(PropertyValue[] pv1, PropertyValue[] pv2) {
        if (pv1.length != pv2.length) {
            return false;
        }
        HashMap<String, Object> hm1 = new HashMap<String, Object>();
        boolean result = true;
        int i = 0;
        for (i = 0; i < pv1.length; ++i) {
            hm1.put(pv1[i].Name, pv1[i].Value);
        }
        for (i = 0; i < pv2.length && result; result &= ValueComparer.equalValue(hm1.get(pv2[i].Name), pv2[i].Value), ++i) {
        }
        return result;
    }

    static boolean compareArrays(Object op1, Object op2) throws Exception {
        if (op1 instanceof PropertyValue[] && op2 instanceof PropertyValue[]) {
            return ValueComparer.compareArrayOfPropertyValue((PropertyValue[])op1, (PropertyValue[])op2);
        }
        boolean result = true;
        if (op1.getClass().getComponentType() == op2.getClass().getComponentType() && Array.getLength(op1) == Array.getLength(op2)) {
            Class<?> zClass = op1.getClass().getComponentType();
            for (int i = 0; i < Array.getLength(op1); ++i) {
                result &= ValueComparer.compareObjects(Array.get(op1, i), Array.get(op2, i));
            }
        } else {
            result = false;
        }
        return result;
    }

    static boolean compareInterfaces(XInterface op1, XInterface op2) {
        return op1 == op2;
    }

    static boolean compareUntil(Class zClass, Class untilClass, Object op1, Object op2) throws Exception {
        boolean result = true;
        Class superClass = zClass.getSuperclass();
        if (superClass != null && superClass != untilClass) {
            result &= ValueComparer.compareUntil(superClass, untilClass, op1, op2);
        }
        Field[] fields = zClass.getDeclaredFields();
        for (int i = 0; i < fields.length && result; ++i) {
            if ((fields[i].getModifiers() & 0x88) != 0) continue;
            Object obj1 = fields[i].get(op1);
            Object obj2 = fields[i].get(op2);
            if (obj1 instanceof Any) {
                try {
                    obj1 = utils.isVoid(obj1) ? null : AnyConverter.toObject((Type)((Any)obj1).getType(), (Object)obj1);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
            }
            if (obj2 instanceof Any) {
                try {
                    obj2 = utils.isVoid(obj2) ? null : AnyConverter.toObject((Type)((Any)obj2).getType(), (Object)obj2);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
            }
            result &= ValueComparer.compareObjects(obj1, obj2);
        }
        return result;
    }

    static boolean compareStructs(Object op1, Object op2) throws Exception {
        boolean result = true;
        result = op1.getClass() != op2.getClass() ? false : ValueComparer.compareUntil(op1.getClass(), Object.class, op1, op2);
        return result;
    }

    static boolean compareThrowable(Throwable op1, Throwable op2) throws Exception {
        boolean result = true;
        if (op1.getClass() != op2.getClass()) {
            result = false;
        } else {
            result = ValueComparer.compareUntil(op1.getClass(), Throwable.class, op1, op2);
            result &= op1.getMessage().equals(op2.getMessage());
        }
        return result;
    }

    static boolean compareEnums(Enum en1, Enum en2) {
        return en1.getValue() == en2.getValue();
    }

    static boolean compareObjects(Object op1, Object op2) throws Exception {
        boolean result = false;
        if (op1 == op2) {
            result = true;
        }
        if (op1 == null || op2 == null) {
            result = op1 == op2;
        } else if (op1.getClass().isPrimitive() && op2.getClass().isPrimitive()) {
            result = op1.equals(op2);
        } else if (op1.getClass() == Byte.class && op2.getClass() == Byte.class) {
            result = op1.equals(op2);
        } else if (op1.getClass() == Type.class && op2.getClass() == Type.class) {
            result = op1.equals(op2);
        } else if (op1.getClass() == Boolean.class && op2.getClass() == Boolean.class) {
            result = op1.equals(op2);
        } else if (op1.getClass() == Short.class && op2.getClass() == Short.class) {
            result = op1.equals(op2);
        } else if (Throwable.class.isAssignableFrom(op1.getClass()) && Throwable.class.isAssignableFrom(op2.getClass())) {
            result = ValueComparer.compareThrowable((Throwable)op1, (Throwable)op2);
        } else if (op1.getClass() == Integer.class && op2.getClass() == Integer.class) {
            result = op1.equals(op2);
        } else if (op1.getClass() == Character.class && op2.getClass() == Character.class) {
            result = op1.equals(op2);
        } else if (op1.getClass() == Long.class && op2.getClass() == Long.class) {
            result = op1.equals(op2);
        } else if (op1.getClass() == Void.class && op2.getClass() == Void.class) {
            result = op1.equals(op2);
        } else if (op1.getClass() == Float.class && op2.getClass() == Float.class) {
            result = op1.equals(op2);
        } else if (op1.getClass() == Double.class && op2.getClass() == Double.class) {
            result = op1.equals(op2);
        } else if (op1.getClass().isArray() && op2.getClass().isArray()) {
            result = ValueComparer.compareArrays(op1, op2);
        } else if (op1.getClass() == Void.class || op2.getClass() == Void.TYPE) {
            result = true;
        } else if (XInterface.class.isAssignableFrom(op1.getClass()) && XInterface.class.isAssignableFrom(op2.getClass())) {
            ValueComparer.compareInterfaces((XInterface)op1, (XInterface)op2);
        } else if (Enum.class.isAssignableFrom(op1.getClass()) && Enum.class.isAssignableFrom(op2.getClass())) {
            ValueComparer.compareEnums((Enum)op1, (Enum)op2);
        } else {
            result = op1.getClass() == String.class && op2.getClass() == String.class ? ((String)op1).equals((String)op2) : ValueComparer.compareStructs(op1, op2);
        }
        return result;
    }
}

