/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.awt.FontDescriptor;
import com.sun.star.awt.FontSlant;
import com.sun.star.awt.Gradient;
import com.sun.star.awt.GradientStyle;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyValue;
import com.sun.star.chart.ChartAxisArrangeOrderType;
import com.sun.star.chart.ChartDataRowSource;
import com.sun.star.chart.ChartErrorCategory;
import com.sun.star.chart.ChartErrorIndicatorType;
import com.sun.star.chart.ChartRegressionCurveType;
import com.sun.star.drawing.BitmapMode;
import com.sun.star.drawing.DashStyle;
import com.sun.star.drawing.Direction3D;
import com.sun.star.drawing.FillStyle;
import com.sun.star.drawing.Hatch;
import com.sun.star.drawing.HatchStyle;
import com.sun.star.drawing.HomogenMatrix3;
import com.sun.star.drawing.LineDash;
import com.sun.star.drawing.LineJoint;
import com.sun.star.drawing.LineStyle;
import com.sun.star.drawing.PolyPolygonBezierCoords;
import com.sun.star.drawing.PolygonFlags;
import com.sun.star.drawing.RectanglePoint;
import com.sun.star.drawing.TextAdjust;
import com.sun.star.drawing.TextAnimationDirection;
import com.sun.star.drawing.TextAnimationKind;
import com.sun.star.drawing.TextFitToSizeType;
import com.sun.star.form.FormButtonType;
import com.sun.star.form.FormSubmitEncoding;
import com.sun.star.form.FormSubmitMethod;
import com.sun.star.form.ListSourceType;
import com.sun.star.form.NavigationBarMode;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.sheet.DataImportMode;
import com.sun.star.sheet.DataPilotFieldOrientation;
import com.sun.star.sheet.GeneralFunction;
import com.sun.star.sheet.ValidationAlertStyle;
import com.sun.star.sheet.ValidationType;
import com.sun.star.style.BreakType;
import com.sun.star.style.DropCapFormat;
import com.sun.star.style.GraphicLocation;
import com.sun.star.style.LineSpacing;
import com.sun.star.style.ParagraphAdjust;
import com.sun.star.style.TabAlign;
import com.sun.star.style.TabStop;
import com.sun.star.table.BorderLine;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellHoriJustify;
import com.sun.star.table.CellOrientation;
import com.sun.star.table.CellVertJustify;
import com.sun.star.table.ShadowFormat;
import com.sun.star.table.TableBorder;
import com.sun.star.table.TableOrientation;
import com.sun.star.text.GraphicCrop;
import com.sun.star.text.SectionFileLink;
import com.sun.star.text.TableColumnSeparator;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.WrapTextMode;
import com.sun.star.text.WritingMode;
import com.sun.star.text.XTextColumns;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Enum;
import com.sun.star.uno.Type;
import com.sun.star.util.CellProtection;
import com.sun.star.util.DateTime;
import com.sun.star.view.PaperOrientation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import util.utils;

public class ValueChanger {
    public static Object changePValue(Object oldValue) {
        Object newValue = null;
        if (oldValue instanceof Any) {
            try {
                oldValue = AnyConverter.toObject((Type)((Any)oldValue).getType(), (Object)oldValue);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        if (oldValue == null) {
            return null;
        }
        if (oldValue instanceof Boolean) {
            boolean oldbool = (Boolean)oldValue;
            newValue = new Boolean(!oldbool);
        } else if (oldValue instanceof Integer) {
            int oldint = (Integer)oldValue;
            newValue = new Integer(oldint + 5);
        } else if (oldValue instanceof Long) {
            long oldlong = (Long)oldValue;
            newValue = new Long(oldlong + 15L);
        } else if (oldValue instanceof Short) {
            short oldshort = (Short)oldValue;
            newValue = new Short((short)(oldshort + 1));
        } else if (oldValue instanceof Byte) {
            byte oldbyte = (Byte)oldValue;
            newValue = new Byte((byte)(oldbyte + 1));
        } else if (oldValue instanceof Float) {
            float oldfloat = ((Float)oldValue).floatValue();
            newValue = new Float((float)((double)oldfloat + 16.7));
        } else if (oldValue instanceof Double) {
            double olddouble = (Double)oldValue;
            newValue = new Double(olddouble + 17.8);
        } else if (oldValue instanceof String) {
            String oldString = (String)oldValue;
            newValue = oldString + "New";
        } else if (oldValue instanceof ChartAxisArrangeOrderType) {
            ChartAxisArrangeOrderType AO1 = ChartAxisArrangeOrderType.AUTO;
            ChartAxisArrangeOrderType AO2 = ChartAxisArrangeOrderType.SIDE_BY_SIDE;
            ChartAxisArrangeOrderType AO3 = ChartAxisArrangeOrderType.STAGGER_EVEN;
            ChartAxisArrangeOrderType AO4 = ChartAxisArrangeOrderType.STAGGER_ODD;
            if (oldValue.equals(AO1)) {
                newValue = AO2;
            }
            if (oldValue.equals(AO2)) {
                newValue = AO3;
            }
            if (oldValue.equals(AO3)) {
                newValue = AO4;
            }
            if (oldValue.equals(AO4)) {
                newValue = AO1;
            }
        } else if (oldValue instanceof PaperOrientation) {
            PaperOrientation OR1 = PaperOrientation.LANDSCAPE;
            PaperOrientation OR2 = PaperOrientation.PORTRAIT;
            newValue = oldValue.equals(OR1) ? OR2 : OR1;
        } else if (oldValue instanceof Locale) {
            Locale Loc1 = new Locale("en", "US", "");
            Locale Loc2 = new Locale("de", "DE", "");
            newValue = oldValue.equals(Loc1) ? Loc2 : Loc1;
        } else if (oldValue instanceof ParagraphAdjust) {
            ParagraphAdjust PA1 = ParagraphAdjust.LEFT;
            ParagraphAdjust PA2 = ParagraphAdjust.CENTER;
            newValue = oldValue.equals(PA1) ? PA2 : PA1;
        } else if (oldValue instanceof LineSpacing) {
            LineSpacing LS = new LineSpacing();
            LineSpacing LSold = (LineSpacing)oldValue;
            LS.Height = (short)(LSold.Height + 1);
            LS.Mode = (short)(LSold.Mode + 1);
            newValue = LS;
        } else if (oldValue instanceof Direction3D) {
            Direction3D D3D = new Direction3D();
            Direction3D D3Dold = (Direction3D)oldValue;
            D3D.DirectionX = D3Dold.DirectionX + 0.5;
            D3D.DirectionY = D3Dold.DirectionY + 0.5;
            D3D.DirectionZ = D3Dold.DirectionZ + 0.5;
            newValue = D3D;
        } else if (oldValue instanceof GraphicLocation) {
            GraphicLocation GL1 = GraphicLocation.AREA;
            GraphicLocation GL2 = GraphicLocation.LEFT_BOTTOM;
            newValue = oldValue.equals(GL1) ? GL2 : GL1;
        } else if (oldValue instanceof TabStop) {
            TabStop TS = new TabStop();
            TabStop TSold = (TabStop)oldValue;
            TabAlign TA1 = TabAlign.CENTER;
            TabAlign TA2 = TabAlign.RIGHT;
            TS.Alignment = TSold.Alignment.equals(TA1) ? TA2 : TA1;
            TS.Position = TSold.Position + 1;
            newValue = TS;
        } else if (oldValue instanceof DropCapFormat) {
            DropCapFormat DCF = new DropCapFormat();
            DropCapFormat DCFold = (DropCapFormat)oldValue;
            DCF.Count = (byte)(DCFold.Count + 1);
            DCF.Distance = (short)(DCFold.Distance + 1);
            DCF.Lines = (byte)(DCFold.Lines + 1);
            newValue = DCF;
        } else if (oldValue instanceof TextContentAnchorType) {
            TextContentAnchorType TCAT1 = TextContentAnchorType.AS_CHARACTER;
            TextContentAnchorType TCAT2 = TextContentAnchorType.AT_CHARACTER;
            TextContentAnchorType TCAT3 = TextContentAnchorType.AT_FRAME;
            TextContentAnchorType TCAT4 = TextContentAnchorType.AT_PAGE;
            TextContentAnchorType TCAT5 = TextContentAnchorType.AT_PARAGRAPH;
            if (oldValue.equals(TCAT1)) {
                newValue = TCAT2;
            }
            if (oldValue.equals(TCAT2)) {
                newValue = TCAT3;
            }
            if (oldValue.equals(TCAT3)) {
                newValue = TCAT4;
            }
            if (oldValue.equals(TCAT4)) {
                newValue = TCAT5;
            }
            if (oldValue.equals(TCAT5)) {
                newValue = TCAT1;
            }
        } else if (oldValue instanceof WrapTextMode) {
            WrapTextMode WTM1 = WrapTextMode.DYNAMIC;
            WrapTextMode WTM2 = WrapTextMode.LEFT;
            WrapTextMode WTM3 = WrapTextMode.NONE;
            WrapTextMode WTM4 = WrapTextMode.PARALLEL;
            WrapTextMode WTM5 = WrapTextMode.RIGHT;
            WrapTextMode WTM6 = WrapTextMode.THROUGHT;
            if (oldValue.equals(WTM1)) {
                newValue = WTM2;
            }
            if (oldValue.equals(WTM2)) {
                newValue = WTM3;
            }
            if (oldValue.equals(WTM3)) {
                newValue = WTM4;
            }
            if (oldValue.equals(WTM4)) {
                newValue = WTM5;
            }
            if (oldValue.equals(WTM5)) {
                newValue = WTM6;
            }
            if (oldValue.equals(WTM6)) {
                newValue = WTM1;
            }
        } else if (oldValue instanceof Size) {
            Size oldSize = (Size)oldValue;
            Size newSize = new Size();
            newSize.Height = oldSize.Height + 1;
            newSize.Width = oldSize.Width + 1;
            newValue = newSize;
        } else if (oldValue instanceof Rectangle) {
            Rectangle oldRectangle = (Rectangle)oldValue;
            Rectangle newRectangle = new Rectangle();
            newRectangle.Height = oldRectangle.Height + 1;
            newRectangle.Width = oldRectangle.Width + 1;
            newRectangle.X = oldRectangle.Y + 1;
            newRectangle.Y = oldRectangle.X + 1;
            newValue = newRectangle;
        } else if (oldValue instanceof Point) {
            Point oldPoint = (Point)oldValue;
            Point newPoint = new Point();
            newPoint.X = oldPoint.X + 1;
            newPoint.Y = oldPoint.Y + 1;
            newValue = newPoint;
        } else if (oldValue instanceof ShadowFormat) {
            ShadowFormat SF = new ShadowFormat();
            ShadowFormat SFold = (ShadowFormat)oldValue;
            SF.IsTransparent = !SFold.IsTransparent;
            SF.ShadowWidth = (short)(SFold.ShadowWidth + 1);
            newValue = SF;
        } else if (oldValue instanceof FontSlant) {
            FontSlant FS1 = FontSlant.DONTKNOW;
            FontSlant FS2 = FontSlant.ITALIC;
            FontSlant FS3 = FontSlant.NONE;
            FontSlant FS4 = FontSlant.OBLIQUE;
            FontSlant FS5 = FontSlant.REVERSE_ITALIC;
            FontSlant FS6 = FontSlant.REVERSE_OBLIQUE;
            if (oldValue.equals(FS1)) {
                newValue = FS2;
            }
            if (oldValue.equals(FS2)) {
                newValue = FS3;
            }
            if (oldValue.equals(FS3)) {
                newValue = FS4;
            }
            if (oldValue.equals(FS4)) {
                newValue = FS5;
            }
            if (oldValue.equals(FS5)) {
                newValue = FS6;
            }
            if (oldValue.equals(FS6)) {
                newValue = FS1;
            }
        } else if (oldValue instanceof CellHoriJustify) {
            CellHoriJustify CHJ1 = CellHoriJustify.BLOCK;
            CellHoriJustify CHJ2 = CellHoriJustify.CENTER;
            CellHoriJustify CHJ3 = CellHoriJustify.LEFT;
            CellHoriJustify CHJ4 = CellHoriJustify.REPEAT;
            CellHoriJustify CHJ5 = CellHoriJustify.RIGHT;
            CellHoriJustify CHJ6 = CellHoriJustify.STANDARD;
            if (oldValue.equals(CHJ1)) {
                newValue = CHJ2;
            }
            if (oldValue.equals(CHJ2)) {
                newValue = CHJ3;
            }
            if (oldValue.equals(CHJ3)) {
                newValue = CHJ4;
            }
            if (oldValue.equals(CHJ4)) {
                newValue = CHJ5;
            }
            if (oldValue.equals(CHJ5)) {
                newValue = CHJ6;
            }
            if (oldValue.equals(CHJ6)) {
                newValue = CHJ1;
            }
        } else if (oldValue instanceof CellVertJustify) {
            CellVertJustify CVJ1 = CellVertJustify.BOTTOM;
            CellVertJustify CVJ2 = CellVertJustify.CENTER;
            CellVertJustify CVJ3 = CellVertJustify.STANDARD;
            CellVertJustify CVJ4 = CellVertJustify.TOP;
            if (oldValue.equals(CVJ1)) {
                newValue = CVJ2;
            }
            if (oldValue.equals(CVJ2)) {
                newValue = CVJ3;
            }
            if (oldValue.equals(CVJ3)) {
                newValue = CVJ4;
            }
            if (oldValue.equals(CVJ4)) {
                newValue = CVJ1;
            }
        } else if (oldValue instanceof CellOrientation) {
            CellOrientation CO1 = CellOrientation.BOTTOMTOP;
            CellOrientation CO2 = CellOrientation.STACKED;
            CellOrientation CO3 = CellOrientation.STANDARD;
            CellOrientation CO4 = CellOrientation.TOPBOTTOM;
            if (oldValue.equals(CO1)) {
                newValue = CO2;
            }
            if (oldValue.equals(CO2)) {
                newValue = CO3;
            }
            if (oldValue.equals(CO3)) {
                newValue = CO4;
            }
            if (oldValue.equals(CO4)) {
                newValue = CO1;
            }
        } else if (oldValue instanceof CellProtection) {
            CellProtection CP = new CellProtection();
            CellProtection CPold = (CellProtection)oldValue;
            CP.IsFormulaHidden = !CPold.IsFormulaHidden;
            CP.IsHidden = !CPold.IsHidden;
            CP.IsLocked = !CPold.IsLocked;
            CP.IsPrintHidden = !CPold.IsPrintHidden;
            newValue = CP;
        } else if (oldValue instanceof TableBorder) {
            TableBorder TBold = (TableBorder)oldValue;
            TableBorder TB = new TableBorder();
            TB.IsBottomLineValid = !TBold.IsBottomLineValid;
            TB.IsDistanceValid = !TBold.IsDistanceValid;
            TB.IsRightLineValid = !TBold.IsRightLineValid;
            TB.IsTopLineValid = !TBold.IsTopLineValid;
            newValue = TB;
        } else if (oldValue instanceof FillStyle) {
            FillStyle FS1 = FillStyle.NONE;
            FillStyle FS2 = FillStyle.SOLID;
            FillStyle FS3 = FillStyle.GRADIENT;
            FillStyle FS4 = FillStyle.HATCH;
            FillStyle FS5 = FillStyle.BITMAP;
            if (oldValue.equals(FS1)) {
                newValue = FS2;
            }
            if (oldValue.equals(FS2)) {
                newValue = FS3;
            }
            if (oldValue.equals(FS3)) {
                newValue = FS4;
            }
            if (oldValue.equals(FS4)) {
                newValue = FS5;
            }
            if (oldValue.equals(FS5)) {
                newValue = FS1;
            }
        } else if (oldValue instanceof Gradient) {
            Gradient _newValue = (Gradient)oldValue;
            _newValue.Angle = (short)(_newValue.Angle + 10);
            _newValue.Border = (short)(_newValue.Border + 1);
            _newValue.EndColor += 1000;
            _newValue.EndIntensity = (short)(_newValue.EndIntensity - 10);
            _newValue.StartColor += 500;
            _newValue.StartIntensity = (short)(_newValue.StartIntensity + 10);
            _newValue.StepCount = (short)(_newValue.StepCount + 50);
            _newValue.Style = GradientStyle.RADIAL;
            _newValue.XOffset = (short)(_newValue.XOffset + 10);
            _newValue.YOffset = (short)(_newValue.YOffset + 10);
            newValue = _newValue;
        } else if (oldValue instanceof GraphicCrop) {
            GraphicCrop _newValue = (GraphicCrop)oldValue;
            _newValue.Bottom += 10;
            _newValue.Left += 10;
            _newValue.Right += 10;
            _newValue.Top += 10;
            newValue = _newValue;
        } else if (oldValue instanceof BitmapMode) {
            BitmapMode bm1 = BitmapMode.NO_REPEAT;
            BitmapMode bm2 = BitmapMode.REPEAT;
            BitmapMode bm3 = BitmapMode.STRETCH;
            if (oldValue.equals(bm1)) {
                newValue = bm2;
            }
            if (oldValue.equals(bm2)) {
                newValue = bm3;
            }
            if (oldValue.equals(bm3)) {
                newValue = bm3;
            }
        } else if (oldValue instanceof TextAdjust) {
            TextAdjust TA1 = TextAdjust.BLOCK;
            TextAdjust TA2 = TextAdjust.CENTER;
            TextAdjust TA3 = TextAdjust.LEFT;
            TextAdjust TA4 = TextAdjust.RIGHT;
            TextAdjust TA5 = TextAdjust.STRETCH;
            if (oldValue.equals(TA1)) {
                newValue = TA2;
            }
            if (oldValue.equals(TA2)) {
                newValue = TA3;
            }
            if (oldValue.equals(TA3)) {
                newValue = TA4;
            }
            if (oldValue.equals(TA4)) {
                newValue = TA5;
            }
            if (oldValue.equals(TA5)) {
                newValue = TA1;
            }
        } else if (oldValue instanceof TextFitToSizeType) {
            TextFitToSizeType TF1 = TextFitToSizeType.ALLLINES;
            TextFitToSizeType TF2 = TextFitToSizeType.NONE;
            TextFitToSizeType TF3 = TextFitToSizeType.PROPORTIONAL;
            TextFitToSizeType TF4 = TextFitToSizeType.RESIZEATTR;
            if (oldValue.equals(TF1)) {
                newValue = TF2;
            }
            if (oldValue.equals(TF2)) {
                newValue = TF3;
            }
            if (oldValue.equals(TF3)) {
                newValue = TF4;
            }
            if (oldValue.equals(TF4)) {
                newValue = TF1;
            }
        } else if (oldValue instanceof TextAnimationKind) {
            TextAnimationKind AK1 = TextAnimationKind.NONE;
            TextAnimationKind AK2 = TextAnimationKind.SLIDE;
            TextAnimationKind AK3 = TextAnimationKind.SCROLL;
            TextAnimationKind AK4 = TextAnimationKind.BLINK;
            TextAnimationKind AK5 = TextAnimationKind.ALTERNATE;
            if (oldValue.equals(AK1)) {
                newValue = AK2;
            }
            if (oldValue.equals(AK2)) {
                newValue = AK3;
            }
            if (oldValue.equals(AK3)) {
                newValue = AK4;
            }
            if (oldValue.equals(AK4)) {
                newValue = AK5;
            }
            if (oldValue.equals(AK5)) {
                newValue = AK1;
            }
        } else if (oldValue instanceof TextAnimationDirection) {
            TextAnimationDirection AD1 = TextAnimationDirection.LEFT;
            TextAnimationDirection AD2 = TextAnimationDirection.RIGHT;
            TextAnimationDirection AD3 = TextAnimationDirection.DOWN;
            TextAnimationDirection AD4 = TextAnimationDirection.UP;
            if (oldValue.equals(AD1)) {
                newValue = AD2;
            }
            if (oldValue.equals(AD2)) {
                newValue = AD3;
            }
            if (oldValue.equals(AD3)) {
                newValue = AD4;
            }
            if (oldValue.equals(AD4)) {
                newValue = AD1;
            }
        } else if (oldValue instanceof LineStyle) {
            LineStyle LS1 = LineStyle.NONE;
            LineStyle LS2 = LineStyle.DASH;
            LineStyle LS3 = LineStyle.SOLID;
            if (oldValue.equals(LS1)) {
                newValue = LS2;
            }
            if (oldValue.equals(LS2)) {
                newValue = LS3;
            }
            if (oldValue.equals(LS3)) {
                newValue = LS1;
            }
        } else if (oldValue instanceof LineJoint) {
            LineJoint LJ1 = LineJoint.BEVEL;
            LineJoint LJ2 = LineJoint.MIDDLE;
            LineJoint LJ3 = LineJoint.MITER;
            LineJoint LJ4 = LineJoint.NONE;
            LineJoint LJ5 = LineJoint.ROUND;
            if (oldValue.equals(LJ1)) {
                newValue = LJ2;
            }
            if (oldValue.equals(LJ2)) {
                newValue = LJ3;
            }
            if (oldValue.equals(LJ3)) {
                newValue = LJ4;
            }
            if (oldValue.equals(LJ4)) {
                newValue = LJ5;
            }
            if (oldValue.equals(LJ5)) {
                newValue = LJ1;
            }
        } else if (oldValue instanceof LineDash) {
            LineDash _newValue = (LineDash)oldValue;
            _newValue.Dashes = (short)(_newValue.Dashes + 1);
            _newValue.DashLen += 10;
            _newValue.Distance += 20;
            _newValue.DotLen += 10;
            _newValue.Dots = (short)(_newValue.Dots + 10);
            _newValue.Style = DashStyle.RECT;
            newValue = _newValue;
        } else if (oldValue instanceof Hatch) {
            Hatch _newValue = (Hatch)oldValue;
            _newValue.Angle += 10;
            _newValue.Color += 1000;
            _newValue.Distance += 10;
            _newValue.Style = HatchStyle.DOUBLE;
        } else if (oldValue instanceof RectanglePoint) {
            RectanglePoint RP1 = RectanglePoint.LEFT_BOTTOM;
            RectanglePoint RP2 = RectanglePoint.LEFT_MIDDLE;
            RectanglePoint RP3 = RectanglePoint.LEFT_TOP;
            RectanglePoint RP4 = RectanglePoint.MIDDLE_BOTTOM;
            RectanglePoint RP5 = RectanglePoint.MIDDLE_MIDDLE;
            RectanglePoint RP6 = RectanglePoint.MIDDLE_TOP;
            RectanglePoint RP7 = RectanglePoint.RIGHT_BOTTOM;
            RectanglePoint RP8 = RectanglePoint.RIGHT_MIDDLE;
            RectanglePoint RP9 = RectanglePoint.RIGHT_TOP;
            if (oldValue.equals(RP1)) {
                newValue = RP2;
            }
            if (oldValue.equals(RP2)) {
                newValue = RP3;
            }
            if (oldValue.equals(RP3)) {
                newValue = RP4;
            }
            if (oldValue.equals(RP4)) {
                newValue = RP5;
            }
            if (oldValue.equals(RP5)) {
                newValue = RP6;
            }
            if (oldValue.equals(RP6)) {
                newValue = RP7;
            }
            if (oldValue.equals(RP7)) {
                newValue = RP8;
            }
            if (oldValue.equals(RP8)) {
                newValue = RP9;
            }
            if (oldValue.equals(RP9)) {
                newValue = RP1;
            }
        } else if (oldValue instanceof ChartErrorCategory) {
            ChartErrorCategory CC1 = ChartErrorCategory.CONSTANT_VALUE;
            ChartErrorCategory CC2 = ChartErrorCategory.ERROR_MARGIN;
            ChartErrorCategory CC3 = ChartErrorCategory.NONE;
            ChartErrorCategory CC4 = ChartErrorCategory.PERCENT;
            ChartErrorCategory CC5 = ChartErrorCategory.STANDARD_DEVIATION;
            ChartErrorCategory CC6 = ChartErrorCategory.VARIANCE;
            if (oldValue.equals(CC1)) {
                newValue = CC2;
            }
            if (oldValue.equals(CC2)) {
                newValue = CC3;
            }
            if (oldValue.equals(CC3)) {
                newValue = CC4;
            }
            if (oldValue.equals(CC4)) {
                newValue = CC5;
            }
            if (oldValue.equals(CC5)) {
                newValue = CC6;
            }
            if (oldValue.equals(CC6)) {
                newValue = CC1;
            }
        } else if (oldValue instanceof ChartErrorIndicatorType) {
            ChartErrorIndicatorType IT1 = ChartErrorIndicatorType.LOWER;
            ChartErrorIndicatorType IT2 = ChartErrorIndicatorType.NONE;
            ChartErrorIndicatorType IT3 = ChartErrorIndicatorType.TOP_AND_BOTTOM;
            ChartErrorIndicatorType IT4 = ChartErrorIndicatorType.UPPER;
            if (oldValue.equals(IT1)) {
                newValue = IT2;
            }
            if (oldValue.equals(IT2)) {
                newValue = IT3;
            }
            if (oldValue.equals(IT3)) {
                newValue = IT4;
            }
            if (oldValue.equals(IT4)) {
                newValue = IT1;
            }
        } else if (oldValue instanceof ChartRegressionCurveType) {
            ChartRegressionCurveType CT1 = ChartRegressionCurveType.EXPONENTIAL;
            ChartRegressionCurveType CT2 = ChartRegressionCurveType.LINEAR;
            ChartRegressionCurveType CT3 = ChartRegressionCurveType.LOGARITHM;
            ChartRegressionCurveType CT4 = ChartRegressionCurveType.NONE;
            ChartRegressionCurveType CT5 = ChartRegressionCurveType.POLYNOMIAL;
            ChartRegressionCurveType CT6 = ChartRegressionCurveType.POWER;
            if (oldValue.equals(CT1)) {
                newValue = CT2;
            }
            if (oldValue.equals(CT2)) {
                newValue = CT3;
            }
            if (oldValue.equals(CT3)) {
                newValue = CT4;
            }
            if (oldValue.equals(CT4)) {
                newValue = CT5;
            }
            if (oldValue.equals(CT5)) {
                newValue = CT6;
            }
            if (oldValue.equals(CT6)) {
                newValue = CT1;
            }
        } else if (oldValue instanceof ChartDataRowSource) {
            ChartDataRowSource RS1 = ChartDataRowSource.COLUMNS;
            ChartDataRowSource RS2 = ChartDataRowSource.ROWS;
            if (oldValue.equals(RS1)) {
                newValue = RS2;
            }
            if (oldValue.equals(RS2)) {
                newValue = RS1;
            }
        } else if (oldValue instanceof FontDescriptor) {
            FontDescriptor _newValue = (FontDescriptor)oldValue;
            _newValue.CharacterWidth += 5.0f;
            _newValue.CharSet = 1;
            _newValue.Family = 1;
            _newValue.Height = (short)(_newValue.Height + 2);
            _newValue.Kerning = !_newValue.Kerning;
            _newValue.Name = "Courier";
            _newValue.Orientation += 45.0f;
            _newValue.Pitch = (short)2;
            _newValue.Slant = FontSlant.REVERSE_ITALIC;
            _newValue.Strikeout = (short)6;
            _newValue.StyleName = "Bold";
            _newValue.Type = (short)4;
            _newValue.Underline = (short)17;
            _newValue.Weight += 5.0f;
            _newValue.Width = (short)(_newValue.Width + 6);
            _newValue.WordLineMode = !_newValue.WordLineMode;
            newValue = _newValue;
        } else if (oldValue instanceof NavigationBarMode) {
            NavigationBarMode BM1 = NavigationBarMode.CURRENT;
            NavigationBarMode BM2 = NavigationBarMode.NONE;
            NavigationBarMode BM3 = NavigationBarMode.PARENT;
            if (oldValue.equals(BM1)) {
                newValue = BM2;
            }
            if (oldValue.equals(BM2)) {
                newValue = BM3;
            }
            if (oldValue.equals(BM3)) {
                newValue = BM1;
            }
        } else if (oldValue instanceof FormSubmitEncoding) {
            FormSubmitEncoding SE1 = FormSubmitEncoding.MULTIPART;
            FormSubmitEncoding SE2 = FormSubmitEncoding.TEXT;
            FormSubmitEncoding SE3 = FormSubmitEncoding.URL;
            if (oldValue.equals(SE1)) {
                newValue = SE2;
            }
            if (oldValue.equals(SE2)) {
                newValue = SE3;
            }
            if (oldValue.equals(SE3)) {
                newValue = SE1;
            }
        } else if (oldValue instanceof FormSubmitMethod) {
            FormSubmitMethod FM1 = FormSubmitMethod.GET;
            FormSubmitMethod FM2 = FormSubmitMethod.POST;
            if (oldValue.equals(FM1)) {
                newValue = FM2;
            }
            if (oldValue.equals(FM2)) {
                newValue = FM1;
            }
        } else if (oldValue instanceof SectionFileLink) {
            SectionFileLink _newValue = new SectionFileLink();
            _newValue.FileURL = utils.getFullTestURL("SwXTextSection.sdw");
            newValue = _newValue;
        } else if (oldValue instanceof BorderLine) {
            BorderLine _newValue = (BorderLine)oldValue;
            _newValue.Color += 2;
            _newValue.InnerLineWidth = (short)(_newValue.InnerLineWidth + 2);
            _newValue.LineDistance = (short)(_newValue.LineDistance + 2);
            _newValue.OuterLineWidth = (short)(_newValue.OuterLineWidth + 3);
            newValue = _newValue;
        } else if (oldValue instanceof XTextColumns) {
            XTextColumns _newValue = (XTextColumns)oldValue;
            _newValue.setColumnCount((short)1);
            newValue = _newValue;
        } else if (oldValue instanceof FormButtonType) {
            FormButtonType BT1 = FormButtonType.PUSH;
            FormButtonType BT2 = FormButtonType.RESET;
            FormButtonType BT3 = FormButtonType.SUBMIT;
            FormButtonType BT4 = FormButtonType.URL;
            if (oldValue.equals(BT1)) {
                newValue = BT2;
            }
            if (oldValue.equals(BT2)) {
                newValue = BT3;
            }
            if (oldValue.equals(BT3)) {
                newValue = BT4;
            }
            if (oldValue.equals(BT4)) {
                newValue = BT1;
            }
        } else if (oldValue instanceof ListSourceType) {
            ListSourceType ST1 = ListSourceType.QUERY;
            ListSourceType ST2 = ListSourceType.SQL;
            ListSourceType ST3 = ListSourceType.SQLPASSTHROUGH;
            ListSourceType ST4 = ListSourceType.TABLE;
            ListSourceType ST5 = ListSourceType.TABLEFIELDS;
            ListSourceType ST6 = ListSourceType.VALUELIST;
            if (oldValue.equals(ST1)) {
                newValue = ST2;
            }
            if (oldValue.equals(ST2)) {
                newValue = ST3;
            }
            if (oldValue.equals(ST3)) {
                newValue = ST4;
            }
            if (oldValue.equals(ST4)) {
                newValue = ST5;
            }
            if (oldValue.equals(ST5)) {
                newValue = ST6;
            }
            if (oldValue.equals(ST6)) {
                newValue = ST1;
            }
        } else if (oldValue instanceof BorderLine) {
            BorderLine _newValue = (BorderLine)oldValue;
            _newValue.Color += 1000;
            _newValue.InnerLineWidth = (short)(_newValue.InnerLineWidth + 2);
            _newValue.LineDistance = (short)(_newValue.LineDistance + 3);
            _newValue.OuterLineWidth = (short)(_newValue.OuterLineWidth + 3);
            newValue = _newValue;
        } else if (oldValue instanceof DataPilotFieldOrientation) {
            DataPilotFieldOrientation FO1 = DataPilotFieldOrientation.PAGE;
            DataPilotFieldOrientation FO2 = DataPilotFieldOrientation.COLUMN;
            DataPilotFieldOrientation FO3 = DataPilotFieldOrientation.DATA;
            DataPilotFieldOrientation FO4 = DataPilotFieldOrientation.HIDDEN;
            DataPilotFieldOrientation FO5 = DataPilotFieldOrientation.ROW;
            if (oldValue.equals(FO1)) {
                newValue = FO2;
            }
            if (oldValue.equals(FO2)) {
                newValue = FO3;
            }
            if (oldValue.equals(FO3)) {
                newValue = FO4;
            }
            if (oldValue.equals(FO4)) {
                newValue = FO5;
            }
            if (oldValue.equals(FO5)) {
                newValue = FO1;
            }
        } else if (oldValue instanceof GeneralFunction) {
            GeneralFunction GF1 = GeneralFunction.NONE;
            GeneralFunction GF2 = GeneralFunction.AVERAGE;
            GeneralFunction GF3 = GeneralFunction.COUNT;
            GeneralFunction GF4 = GeneralFunction.COUNTNUMS;
            GeneralFunction GF5 = GeneralFunction.MAX;
            GeneralFunction GF6 = GeneralFunction.MIN;
            GeneralFunction GF7 = GeneralFunction.AUTO;
            GeneralFunction GF8 = GeneralFunction.PRODUCT;
            GeneralFunction GF9 = GeneralFunction.STDEV;
            GeneralFunction GF10 = GeneralFunction.STDEVP;
            GeneralFunction GF11 = GeneralFunction.SUM;
            GeneralFunction GF12 = GeneralFunction.VAR;
            GeneralFunction GF13 = GeneralFunction.VARP;
            if (oldValue.equals(GF1)) {
                newValue = GF2;
            }
            if (oldValue.equals(GF2)) {
                newValue = GF3;
            }
            if (oldValue.equals(GF3)) {
                newValue = GF4;
            }
            if (oldValue.equals(GF4)) {
                newValue = GF5;
            }
            if (oldValue.equals(GF5)) {
                newValue = GF6;
            }
            if (oldValue.equals(GF6)) {
                newValue = GF7;
            }
            if (oldValue.equals(GF7)) {
                newValue = GF8;
            }
            if (oldValue.equals(GF8)) {
                newValue = GF9;
            }
            if (oldValue.equals(GF9)) {
                newValue = GF10;
            }
            if (oldValue.equals(GF10)) {
                newValue = GF11;
            }
            if (oldValue.equals(GF11)) {
                newValue = GF12;
            }
            if (oldValue.equals(GF12)) {
                newValue = GF13;
            }
            if (oldValue.equals(GF13)) {
                newValue = GF1;
            }
        } else if (oldValue instanceof CellAddress) {
            CellAddress _newValue = (CellAddress)oldValue;
            ++_newValue.Column;
            ++_newValue.Row;
            newValue = _newValue;
        } else if (oldValue instanceof TableOrientation) {
            TableOrientation TO1 = TableOrientation.COLUMNS;
            TableOrientation TO2 = TableOrientation.ROWS;
            newValue = oldValue.equals(TO1) ? TO2 : TO1;
        } else if (oldValue instanceof DataImportMode) {
            DataImportMode DIM1 = DataImportMode.NONE;
            DataImportMode DIM2 = DataImportMode.QUERY;
            DataImportMode DIM3 = DataImportMode.SQL;
            DataImportMode DIM4 = DataImportMode.TABLE;
            if (oldValue.equals(DIM1)) {
                newValue = DIM2;
            }
            if (oldValue.equals(DIM2)) {
                newValue = DIM3;
            }
            if (oldValue.equals(DIM3)) {
                newValue = DIM4;
            }
            if (oldValue.equals(DIM4)) {
                newValue = DIM1;
            }
        } else if (oldValue instanceof BreakType) {
            BreakType BT1 = BreakType.COLUMN_AFTER;
            BreakType BT2 = BreakType.COLUMN_BEFORE;
            BreakType BT3 = BreakType.COLUMN_BOTH;
            BreakType BT4 = BreakType.PAGE_AFTER;
            BreakType BT5 = BreakType.PAGE_BEFORE;
            BreakType BT6 = BreakType.PAGE_BOTH;
            BreakType BT7 = BreakType.NONE;
            if (oldValue.equals(BT1)) {
                newValue = BT2;
            }
            if (oldValue.equals(BT2)) {
                newValue = BT3;
            }
            if (oldValue.equals(BT3)) {
                newValue = BT4;
            }
            if (oldValue.equals(BT4)) {
                newValue = BT5;
            }
            if (oldValue.equals(BT6)) {
                newValue = BT6;
            }
            if (oldValue.equals(BT6)) {
                newValue = BT7;
            }
            if (oldValue.equals(BT7)) {
                newValue = BT1;
            }
        } else if (oldValue instanceof PropertyValue) {
            PropertyValue newVal = new PropertyValue();
            newVal.Name = ((PropertyValue)oldValue).Name;
            newVal.Value = ValueChanger.changePValue(((PropertyValue)oldValue).Value);
            newValue = newVal;
        } else if (oldValue instanceof ValidationAlertStyle) {
            ValidationAlertStyle VAS1 = ValidationAlertStyle.INFO;
            ValidationAlertStyle VAS2 = ValidationAlertStyle.MACRO;
            ValidationAlertStyle VAS3 = ValidationAlertStyle.STOP;
            ValidationAlertStyle VAS4 = ValidationAlertStyle.WARNING;
            if (oldValue.equals(VAS1)) {
                newValue = VAS2;
            }
            if (oldValue.equals(VAS2)) {
                newValue = VAS3;
            }
            if (oldValue.equals(VAS3)) {
                newValue = VAS4;
            }
            if (oldValue.equals(VAS4)) {
                newValue = VAS1;
            }
        } else if (oldValue instanceof ValidationType) {
            ValidationType VT1 = ValidationType.ANY;
            ValidationType VT2 = ValidationType.CUSTOM;
            ValidationType VT3 = ValidationType.DATE;
            ValidationType VT4 = ValidationType.DECIMAL;
            ValidationType VT5 = ValidationType.LIST;
            ValidationType VT6 = ValidationType.TEXT_LEN;
            ValidationType VT7 = ValidationType.TIME;
            ValidationType VT8 = ValidationType.WHOLE;
            if (oldValue.equals(VT1)) {
                newValue = VT2;
            }
            if (oldValue.equals(VT2)) {
                newValue = VT3;
            }
            if (oldValue.equals(VT3)) {
                newValue = VT4;
            }
            if (oldValue.equals(VT4)) {
                newValue = VT5;
            }
            if (oldValue.equals(VT5)) {
                newValue = VT6;
            }
            if (oldValue.equals(VT6)) {
                newValue = VT7;
            }
            if (oldValue.equals(VT7)) {
                newValue = VT8;
            }
            if (oldValue.equals(VT8)) {
                newValue = VT1;
            }
        } else if (oldValue instanceof WritingMode) {
            newValue = oldValue.equals(WritingMode.LR_TB) ? WritingMode.TB_RL : WritingMode.LR_TB;
        } else if (oldValue instanceof Enum) {
            try {
                Class<?> enumClass = oldValue.getClass();
                Field[] flds = enumClass.getFields();
                newValue = null;
                for (int i = 0; i < flds.length; ++i) {
                    if (!Enum.class.equals(flds[i].getType().getSuperclass())) continue;
                    Enum value = (Enum)flds[i].get(null);
                    if (newValue != null || value.equals(oldValue)) continue;
                    newValue = value;
                    break;
                }
            }
            catch (Exception e) {
                System.err.println("Exception occured while changing Enumeration value:");
                e.printStackTrace(System.err);
            }
            if (newValue == null) {
                newValue = oldValue;
            }
        } else if (oldValue instanceof TabStop[]) {
            TabStop[] _newValue = (TabStop[])oldValue;
            if (_newValue.length == 0) {
                _newValue = new TabStop[1];
            }
            TabStop sep = new TabStop();
            ++sep.Position;
            _newValue[0] = sep;
            newValue = _newValue;
        } else if (oldValue instanceof short[]) {
            short[] oldArr = (short[])oldValue;
            int len = oldArr.length;
            short[] newArr = new short[len + 1];
            for (int i = 0; i < len; ++i) {
                newArr[i] = (short)(oldArr[i] + 1);
            }
            newArr[len] = 5;
            newValue = newArr;
        } else if (oldValue instanceof String[]) {
            String[] oldArr = (String[])oldValue;
            int len = oldArr.length;
            String[] newArr = new String[len + 1];
            for (int i = 0; i < len; ++i) {
                newArr[i] = "_" + oldArr[i];
            }
            newArr[len] = "_dummy";
            newValue = newArr;
        } else if (oldValue instanceof PropertyValue) {
            PropertyValue newVal = new PropertyValue();
            newVal.Name = ((PropertyValue)oldValue).Name;
            newVal.Value = ValueChanger.changePValue(((PropertyValue)oldValue).Value);
            newValue = newVal;
        } else if (oldValue instanceof DateTime) {
            DateTime oldDT = (DateTime)oldValue;
            DateTime newDT = new DateTime();
            newDT.Day = (short)(oldDT.Day + 1);
            newDT.Hours = (short)(oldDT.Hours + 1);
            newValue = newDT;
        } else if (oldValue instanceof TableColumnSeparator) {
            TableColumnSeparator oldTCS = (TableColumnSeparator)oldValue;
            TableColumnSeparator newTCS = new TableColumnSeparator();
            newTCS.IsVisible = !oldTCS.IsVisible;
            newTCS.Position = (short)(oldTCS.Position + 1);
            newValue = newTCS;
        } else if (oldValue instanceof HomogenMatrix3) {
            HomogenMatrix3 oldHM = (HomogenMatrix3)oldValue;
            HomogenMatrix3 newHM = new HomogenMatrix3();
            newHM.Line1.Column1 = oldHM.Line1.Column1 + 1.0;
            newHM.Line2.Column2 = oldHM.Line2.Column2 + 1.0;
            newHM.Line3.Column3 = oldHM.Line3.Column3 + 1.0;
            newValue = newHM;
        } else if (oldValue instanceof PolyPolygonBezierCoords) {
            PolyPolygonBezierCoords oldPPC = (PolyPolygonBezierCoords)oldValue;
            PolyPolygonBezierCoords newPPC = new PolyPolygonBezierCoords();
            newPPC.Coordinates = oldPPC.Coordinates;
            newPPC.Flags = oldPPC.Flags;
            PolygonFlags[][] fArray = new PolygonFlags[1][1];
            PolygonFlags[] flags = new PolygonFlags[]{PolygonFlags.NORMAL};
            fArray[0] = flags;
            Point[][] pArray = new Point[1][1];
            Point[] points = new Point[1];
            Point aPoint = new Point();
            aPoint.X = 1;
            aPoint.Y = 2;
            points[0] = aPoint;
            pArray[0] = points;
            if (oldPPC.Coordinates.length == 0) {
                newPPC.Coordinates = pArray;
                newPPC.Flags = fArray;
            } else if (oldPPC.Coordinates[0].length == 0) {
                newPPC.Coordinates = pArray;
                newPPC.Flags = fArray;
            } else {
                newPPC.Coordinates[0][0].X = oldPPC.Coordinates[0][0].X + 1;
                newPPC.Coordinates[0][0].Y = oldPPC.Coordinates[0][0].Y + 1;
            }
            newValue = newPPC;
        } else if (oldValue.getClass().isArray()) {
            Class<?> arrType = oldValue.getClass().getComponentType();
            newValue = Array.newInstance(arrType, Array.getLength(oldValue));
            for (int i = 0; i < Array.getLength(newValue); ++i) {
                if (!arrType.isPrimitive()) {
                    Object elem = ValueChanger.changePValue(Array.get(oldValue, i));
                    Array.set(newValue, i, elem);
                    continue;
                }
                if (Boolean.TYPE.equals(arrType)) {
                    Array.setBoolean(newValue, i, !Array.getBoolean(oldValue, i));
                    continue;
                }
                if (Byte.TYPE.equals(arrType)) {
                    Array.setByte(newValue, i, (byte)(Array.getByte(oldValue, i) + 1));
                    continue;
                }
                if (Character.TYPE.equals(arrType)) {
                    Array.setChar(newValue, i, (char)(Array.getChar(oldValue, i) + '\u0001'));
                    continue;
                }
                if (Double.TYPE.equals(arrType)) {
                    Array.setDouble(newValue, i, Array.getDouble(oldValue, i) + 1.0);
                    continue;
                }
                if (Float.TYPE.equals(arrType)) {
                    Array.setFloat(newValue, i, Array.getFloat(oldValue, i) + 1.0f);
                    continue;
                }
                if (Integer.TYPE.equals(arrType)) {
                    Array.setInt(newValue, i, Array.getInt(oldValue, i) + 1);
                    continue;
                }
                if (Long.TYPE.equals(arrType)) {
                    Array.setLong(newValue, i, Array.getLong(oldValue, i) + 1L);
                    continue;
                }
                if (!Short.TYPE.equals(arrType)) continue;
                Array.setShort(newValue, i, (short)(Array.getShort(oldValue, i) + 1));
            }
        } else if (ValueChanger.isStructure(oldValue)) {
            Class<?> clazz = oldValue.getClass();
            try {
                newValue = clazz.newInstance();
                Field[] fields = clazz.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    if ((fields[i].getModifiers() & 1) == 0) continue;
                    Class<?> fType = fields[i].getType();
                    Field field = fields[i];
                    if (!fType.isPrimitive()) {
                        field.set(newValue, ValueChanger.changePValue(field.get(oldValue)));
                        continue;
                    }
                    if (Boolean.TYPE.equals(fType)) {
                        field.setBoolean(newValue, !field.getBoolean(oldValue));
                        continue;
                    }
                    if (Byte.TYPE.equals(fType)) {
                        field.setByte(newValue, (byte)(field.getByte(oldValue) + 1));
                        continue;
                    }
                    if (Character.TYPE.equals(fType)) {
                        field.setChar(newValue, (char)(field.getChar(oldValue) + '\u0001'));
                        continue;
                    }
                    if (Double.TYPE.equals(fType)) {
                        field.setDouble(newValue, field.getDouble(oldValue) + 1.0);
                        continue;
                    }
                    if (Float.TYPE.equals(fType)) {
                        field.setFloat(newValue, field.getFloat(oldValue) + 1.0f);
                        continue;
                    }
                    if (Integer.TYPE.equals(fType)) {
                        field.setInt(newValue, field.getInt(oldValue) + 1);
                        continue;
                    }
                    if (Long.TYPE.equals(fType)) {
                        field.setLong(newValue, field.getLong(oldValue) + 1L);
                        continue;
                    }
                    if (!Short.TYPE.equals(fType)) continue;
                    field.setShort(newValue, (short)(field.getShort(oldValue) + 1));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("ValueChanger don't know type " + oldValue.getClass());
        }
        return newValue;
    }

    private static boolean isStructure(Object val) {
        boolean result = true;
        Class<?> clazz = val.getClass();
        Method[] meth = clazz.getDeclaredMethods();
        for (int i = 0; i < meth.length; ++i) {
            result &= (meth[i].getModifiers() & 1) == 0;
        }
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int mod = fields[i].getModifiers();
            result &= (mod & 1) == 0 || (mod & 8) == 0 && (mod & 0x10) == 0;
        }
        return result;
    }
}

