/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.awt.XControlModel;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.table.XCell;
import com.sun.star.text.XDocumentIndex;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.util.Hashtable;
import util.BookmarkDsc;
import util.DesktopTools;
import util.FootnoteDsc;
import util.FrameDsc;
import util.InstCreator;
import util.ReferenceMarkDsc;
import util.ShapeDsc;
import util.TableDsc;

public class SOfficeFactory {
    private static Hashtable lookup = new Hashtable(10);
    protected XComponentLoader oCLoader;

    private SOfficeFactory(XMultiServiceFactory xMSF) {
        Object oInterface;
        try {
            oInterface = xMSF.createInstance("com.sun.star.frame.Desktop");
        }
        catch (com.sun.star.uno.Exception e) {
            throw new java.lang.IllegalArgumentException("Desktop Service not available");
        }
        XDesktop oDesktop = UnoRuntime.queryInterface(XDesktop.class, oInterface);
        this.oCLoader = UnoRuntime.queryInterface(XComponentLoader.class, (Object)oDesktop);
    }

    public static SOfficeFactory getFactory(XMultiServiceFactory xMSF) {
        SOfficeFactory soFactory = (SOfficeFactory)lookup.get(new Integer(xMSF.hashCode()).toString());
        if (soFactory == null) {
            soFactory = new SOfficeFactory(xMSF);
            lookup.put(new Integer(xMSF.hashCode()).toString(), soFactory);
        }
        return soFactory;
    }

    public XTextDocument createTextDoc(String frameName) throws com.sun.star.uno.Exception {
        XComponent oDoc = this.openDoc("swriter", frameName);
        if (oDoc != null) {
            DesktopTools.bringWindowToFront(oDoc);
            return UnoRuntime.queryInterface(XTextDocument.class, (Object)oDoc);
        }
        return null;
    }

    public XTextDocument createTextDoc(String frameName, PropertyValue[] mediaDescriptor) throws com.sun.star.uno.Exception {
        XComponent oDoc = this.openDoc("swriter", frameName, mediaDescriptor);
        if (oDoc != null) {
            DesktopTools.bringWindowToFront(oDoc);
            return UnoRuntime.queryInterface(XTextDocument.class, (Object)oDoc);
        }
        return null;
    }

    public XSpreadsheetDocument createCalcDoc(String frameName) throws com.sun.star.uno.Exception {
        XComponent oDoc = this.openDoc("scalc", frameName);
        if (oDoc != null) {
            DesktopTools.bringWindowToFront(oDoc);
            return UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)oDoc);
        }
        return null;
    }

    public XSpreadsheetDocument createCalcDoc(String frameName, PropertyValue[] mediaDescriptor) throws com.sun.star.uno.Exception {
        XComponent oDoc = this.openDoc("scalc", frameName, mediaDescriptor);
        if (oDoc != null) {
            DesktopTools.bringWindowToFront(oDoc);
            return UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)oDoc);
        }
        return null;
    }

    public XComponent createDrawDoc(String frameName) throws com.sun.star.uno.Exception {
        return this.openDoc("sdraw", frameName);
    }

    public XComponent createDrawDoc(String frameName, PropertyValue[] mediaDescriptor) throws com.sun.star.uno.Exception {
        return this.openDoc("sdraw", frameName, mediaDescriptor);
    }

    public XComponent createImpressDoc(String frameName) throws com.sun.star.uno.Exception {
        return this.openDoc("simpress", frameName);
    }

    public XComponent createImpressDoc(String frameName, PropertyValue[] mediaDescriptor) throws com.sun.star.uno.Exception {
        return this.openDoc("simpress", frameName, mediaDescriptor);
    }

    public XComponent createMathDoc(String frameName) throws com.sun.star.uno.Exception {
        return this.openDoc("smath", frameName);
    }

    public XComponent createMathDoc(String frameName, PropertyValue[] mediaDescriptor) throws com.sun.star.uno.Exception {
        return this.openDoc("smath", frameName, mediaDescriptor);
    }

    public XChartDocument createChartDoc(String frameName) throws com.sun.star.uno.Exception {
        XComponent oDoc = this.loadDocument("private:factory/schart");
        if (oDoc != null) {
            DesktopTools.bringWindowToFront(oDoc);
            return UnoRuntime.queryInterface(XChartDocument.class, (Object)oDoc);
        }
        return null;
    }

    public static XTextTable createTextTable(XTextDocument xTextDoc) throws com.sun.star.uno.Exception {
        TableDsc tDsc = new TableDsc();
        InstCreator instCreate = new InstCreator(xTextDoc, tDsc);
        XTextTable oTable = (XTextTable)instCreate.getInstance();
        return oTable;
    }

    public static XTextTable createTextTable(XTextDocument xTextDoc, int rows, int columns) throws com.sun.star.uno.Exception {
        TableDsc tDsc = new TableDsc(rows, columns);
        InstCreator instCreate = new InstCreator(xTextDoc, tDsc);
        XTextTable oTable = (XTextTable)instCreate.getInstance();
        return oTable;
    }

    public static XTextFrame createTextFrame(XTextDocument xTextDoc) throws com.sun.star.uno.Exception {
        FrameDsc tDsc = new FrameDsc();
        InstCreator instCreate = new InstCreator(xTextDoc, tDsc);
        XTextFrame oFrame = (XTextFrame)instCreate.getInstance();
        return oFrame;
    }

    public static XTextFrame createTextFrame(XTextDocument xTextDoc, int height, int width) {
        FrameDsc tDsc = new FrameDsc(height, width);
        InstCreator instCreate = new InstCreator(xTextDoc, tDsc);
        XTextFrame oFrame = (XTextFrame)instCreate.getInstance();
        return oFrame;
    }

    public static void insertString(XTextDocument xTextDoc, String cString) throws com.sun.star.uno.Exception {
        XText xText = xTextDoc.getText();
        XText oText = UnoRuntime.queryInterface(XText.class, (Object)xText);
        XTextCursor oCursor = oText.createTextCursor();
        oText.insertString(oCursor, cString, false);
    }

    public static void insertTextContent(XTextDocument xTextDoc, XTextContent xCont) throws IllegalArgumentException {
        XText xText = xTextDoc.getText();
        XText oText = UnoRuntime.queryInterface(XText.class, (Object)xText);
        XTextCursor oCursor = oText.createTextCursor();
        oText.insertTextContent(oCursor, xCont, false);
    }

    public static XCell getFirstTableCell(XTextContent oTable) {
        String[] CellNames = ((XTextTable)oTable).getCellNames();
        XCell oCell = ((XTextTable)oTable).getCellByName(CellNames[0]);
        return oCell;
    }

    public static XTextContent createBookmark(XTextDocument xTextDoc) throws com.sun.star.uno.Exception {
        BookmarkDsc tDsc = new BookmarkDsc();
        InstCreator instCreate = new InstCreator(xTextDoc, tDsc);
        XTextContent oBookmark = (XTextContent)instCreate.getInstance();
        return oBookmark;
    }

    public static XTextContent createReferenceMark(XTextDocument xTextDoc) throws com.sun.star.uno.Exception {
        ReferenceMarkDsc tDsc = new ReferenceMarkDsc();
        InstCreator instCreate = new InstCreator(xTextDoc, tDsc);
        XTextContent oReferenceMark = (XTextContent)instCreate.getInstance();
        return oReferenceMark;
    }

    public static XTextContent createFootnote(XTextDocument xTextDoc) throws com.sun.star.uno.Exception {
        FootnoteDsc tDsc = new FootnoteDsc();
        InstCreator instCreate = new InstCreator(xTextDoc, tDsc);
        XTextContent oFootnote = (XTextContent)instCreate.getInstance();
        return oFootnote;
    }

    public static XTextContent createIndex(XTextDocument xTextDoc, String kind) throws com.sun.star.uno.Exception {
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xTextDoc);
        Object oInt = oDocMSF.createInstance(kind);
        XTextContent xTC = UnoRuntime.queryInterface(XDocumentIndex.class, oInt);
        return xTC;
    }

    public static XSpreadsheet createSpreadsheet(XSpreadsheetDocument oDoc) throws com.sun.star.uno.Exception {
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oDoc);
        Object oInt = oDocMSF.createInstance("com.sun.star.sheet.Spreadsheet");
        XSpreadsheet oSpreadsheet = UnoRuntime.queryInterface(XSpreadsheet.class, oInt);
        return oSpreadsheet;
    }

    public static XIndexAccess getTableCollection(XTextDocument oDoc) {
        XTextTablesSupplier oTTS = UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)oDoc);
        XNameAccess oNA = oTTS.getTextTables();
        XIndexAccess oIA = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oNA);
        return oIA;
    }

    public static String getUniqueName(XInterface oInterface, String prefix) {
        XNameAccess oNameAccess = UnoRuntime.queryInterface(XNameAccess.class, (Object)oInterface);
        if (oNameAccess == null) {
            return null;
        }
        int i = 0;
        while (oNameAccess.hasByName(prefix + i)) {
            ++i;
        }
        return prefix + i;
    }

    public XShape createShape(XComponent oDoc, int height, int width, int x, int y, String kind) {
        ShapeDsc sDsc = new ShapeDsc(height, width, x, y, kind);
        InstCreator instCreate = new InstCreator(oDoc, sDsc);
        XShape oShape = (XShape)instCreate.getInstance();
        return oShape;
    }

    public XDiagram createDiagram(XComponent oDoc, String kind) {
        XInterface oInterface = null;
        XDiagram oDiagram = null;
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oDoc);
        try {
            oInterface = (XInterface)oDocMSF.createInstance("com.sun.star.chart." + kind);
            oDiagram = UnoRuntime.queryInterface(XDiagram.class, (Object)oInterface);
        }
        catch (Exception e) {
            System.out.println("Couldn't create " + kind + "-Diagram " + e);
        }
        return oDiagram;
    }

    public XInterface createControl(XComponent oDoc, String kind) {
        XInterface oControl = null;
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oDoc);
        try {
            oControl = (XInterface)oDocMSF.createInstance("com.sun.star.form.component." + kind);
        }
        catch (Exception e) {
            System.out.println("Couldn't create instance " + kind + ": " + e);
        }
        return oControl;
    }

    public Object createInstance(XComponent oDoc, String kind) {
        Object oInstance = null;
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oDoc);
        try {
            oInstance = oDocMSF.createInstance(kind);
        }
        catch (Exception e) {
            System.out.println("Couldn't create instance " + kind + ": " + e);
        }
        return oInstance;
    }

    public XControlShape createControlShape(XComponent oDoc, int height, int width, int x, int y, String kind) {
        Size size = new Size();
        Point position = new Point();
        XControlShape oCShape = null;
        XControlModel aControl = null;
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oDoc);
        try {
            Object oInt = oDocMSF.createInstance("com.sun.star.drawing.ControlShape");
            Object aCon = oDocMSF.createInstance("com.sun.star.form.component." + kind);
            aControl = UnoRuntime.queryInterface(XControlModel.class, aCon);
            oCShape = UnoRuntime.queryInterface(XControlShape.class, oInt);
            size.Height = height;
            size.Width = width;
            position.X = x;
            position.Y = y;
            oCShape.setSize(size);
            oCShape.setPosition(position);
        }
        catch (Exception e) {
            System.out.println("Couldn't create instance " + e);
        }
        try {
            oCShape.setControl(aControl);
        }
        catch (Exception e) {
            System.out.println("Couldn't get Control " + e);
        }
        return oCShape;
    }

    public XComponent loadDocument(String fileName) throws IllegalArgumentException, IOException, com.sun.star.uno.Exception {
        String frameName = "_blank";
        PropertyValue[] szEmptyArgs = new PropertyValue[0];
        XComponent oDoc = this.oCLoader.loadComponentFromURL(fileName, frameName, 0, szEmptyArgs);
        if (oDoc == null) {
            return null;
        }
        DesktopTools.bringWindowToFront(oDoc);
        return oDoc;
    }

    public XComponent loadDocument(String fileName, PropertyValue[] Args) throws IllegalArgumentException, IOException, com.sun.star.uno.Exception {
        String frameName = "_blank";
        XComponent oDoc = this.oCLoader.loadComponentFromURL(fileName, frameName, 0, Args);
        if (oDoc == null) {
            return null;
        }
        DesktopTools.bringWindowToFront(oDoc);
        return oDoc;
    }

    public XComponent openDoc(String kind, String frameName) throws IllegalArgumentException, IOException, com.sun.star.uno.Exception {
        PropertyValue[] Args = null;
        if (kind.equals("simpress")) {
            Args = new PropertyValue[1];
            PropertyValue Arg = new PropertyValue();
            Arg.Name = "OpenFlags";
            Arg.Value = "S";
            Arg.Handle = -1;
            Arg.State = PropertyState.DEFAULT_VALUE;
            Args[0] = Arg;
        } else {
            Args = new PropertyValue[]{};
        }
        if (frameName == null) {
            frameName = "_blank";
        }
        XComponent oDoc = this.oCLoader.loadComponentFromURL("private:factory/" + kind, frameName, 40, Args);
        DesktopTools.bringWindowToFront(oDoc);
        return oDoc;
    }

    public XComponent openDoc(String kind, String frameName, PropertyValue[] mediaDescriptor) throws IllegalArgumentException, IOException, com.sun.star.uno.Exception {
        if (frameName == null) {
            frameName = "_blank";
        }
        XComponent oDoc = this.oCLoader.loadComponentFromURL("private:factory/" + kind, frameName, 40, mediaDescriptor);
        DesktopTools.bringWindowToFront(oDoc);
        return oDoc;
    }

    public Object queryXServiceInfo(Object oObj) {
        if (oObj != null) {
            XServiceInfo oInfo = UnoRuntime.queryInterface(XServiceInfo.class, oObj);
            System.out.println("!!!! XServiceInfo n.a. !!!! ");
        } else {
            System.out.println("Object is empty!!!! ");
        }
        return null;
    }
}

