/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.RegistryKeyType;
import com.sun.star.registry.RegistryValueType;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;

public class RegistryTools {
    public static XSimpleRegistry createRegistryService(XMultiServiceFactory xMSF) throws Exception {
        Object oInterface = xMSF.createInstance("com.sun.star.registry.SimpleRegistry");
        return UnoRuntime.queryInterface(XSimpleRegistry.class, oInterface);
    }

    public static XSimpleRegistry openRegistry(String file, XMultiServiceFactory xMSF) throws Exception {
        XSimpleRegistry reg = RegistryTools.createRegistryService(xMSF);
        reg.open(file, false, true);
        return reg;
    }

    public static boolean compareKeys(XRegistryKey key1, XRegistryKey key2) {
        String keyName2;
        if (key1 == null || key2 == null || !key1.isValid() || !key2.isValid()) {
            return false;
        }
        String keyName1 = RegistryTools.getShortKeyName(key1.getKeyName());
        if (!keyName1.equals(keyName2 = RegistryTools.getShortKeyName(key2.getKeyName()))) {
            return false;
        }
        try {
            if (key1.getValueType() != key2.getValueType()) {
                return false;
            }
        }
        catch (InvalidRegistryException e) {
            return false;
        }
        try {
            RegistryValueType type = key1.getValueType();
            if (type.equals(RegistryValueType.ASCII)) {
                if (!key1.getAsciiValue().equals(key2.getAsciiValue())) {
                    return false;
                }
            } else if (type.equals(RegistryValueType.STRING)) {
                if (!key1.getStringValue().equals(key2.getStringValue())) {
                    return false;
                }
            } else if (type.equals(RegistryValueType.LONG)) {
                if (key1.getLongValue() != key2.getLongValue()) {
                    return false;
                }
            } else if (type.equals(RegistryValueType.BINARY)) {
                byte[] bin2;
                byte[] bin1 = key1.getBinaryValue();
                if (bin1.length != (bin2 = key2.getBinaryValue()).length) {
                    return false;
                }
                for (int i = 0; i < bin1.length; ++i) {
                    if (bin1[i] == bin2[i]) continue;
                    return false;
                }
            } else if (type.equals(RegistryValueType.ASCIILIST)) {
                String[] list2;
                String[] list1 = key1.getAsciiListValue();
                if (list1.length != (list2 = key2.getAsciiListValue()).length) {
                    return false;
                }
                for (int i = 0; i < list1.length; ++i) {
                    if (list1[i].equals(list2[i])) continue;
                    return false;
                }
            } else if (type.equals(RegistryValueType.STRINGLIST)) {
                String[] list2;
                String[] list1 = key1.getStringListValue();
                if (list1.length != (list2 = key2.getStringListValue()).length) {
                    return false;
                }
                for (int i = 0; i < list1.length; ++i) {
                    if (list1[i].equals(list2[i])) continue;
                    return false;
                }
            } else if (type.equals(RegistryValueType.LONGLIST)) {
                int[] list2;
                int[] list1 = key1.getLongListValue();
                if (list1.length != (list2 = key2.getLongListValue()).length) {
                    return false;
                }
                for (int i = 0; i < list1.length; ++i) {
                    if (list1[i] == list2[i]) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getShortKeyName(String keyName) {
        if (keyName == null) {
            return null;
        }
        int idx = keyName.lastIndexOf("/");
        if (idx < 0) {
            return keyName;
        }
        return keyName.substring(idx + 1);
    }

    protected static boolean compareKeyTrees(XRegistryKey tree1, XRegistryKey tree2, boolean compareRoot) {
        if (compareRoot && !RegistryTools.compareKeys(tree1, tree2)) {
            return false;
        }
        try {
            String[] keyNames1 = tree1.getKeyNames();
            String[] keyNames2 = tree2.getKeyNames();
            if (keyNames1 == null && keyNames2 == null) {
                return true;
            }
            if (keyNames1 == null || keyNames2 == null || keyNames2.length != keyNames1.length) {
                return false;
            }
            for (int i = 0; i < keyNames1.length; ++i) {
                String keyName = RegistryTools.getShortKeyName(keyNames1[i]);
                XRegistryKey key2 = tree2.openKey(keyName);
                if (key2 == null) {
                    return false;
                }
                if (!tree1.getKeyType(keyName).equals(tree2.getKeyType(keyName))) {
                    return false;
                }
                if (!(tree1.getKeyType(keyName).equals(RegistryKeyType.LINK) ? !RegistryTools.getShortKeyName(tree1.getLinkTarget(keyName)).equals(RegistryTools.getShortKeyName(tree2.getLinkTarget(keyName))) : !RegistryTools.compareKeyTrees(tree1.openKey(keyName), tree2.openKey(keyName), true))) continue;
                return false;
            }
        }
        catch (InvalidRegistryException e) {
            return false;
        }
        return true;
    }

    public static boolean compareKeyTrees(XRegistryKey tree1, XRegistryKey tree2) {
        return RegistryTools.compareKeyTrees(tree1, tree2, false);
    }

    public static void printRegistryInfo(XSimpleRegistry reg, PrintWriter out) {
        try {
            RegistryTools.printRegistryInfo(reg.getRootKey(), out);
        }
        catch (InvalidRegistryException e) {
            out.println("!!! Can't open root registry key for info printing");
        }
    }

    public static void printRegistryInfo(XRegistryKey root, PrintWriter out) {
        if (root == null) {
            out.println("/(null)");
            return;
        }
        out.println("/");
        try {
            RegistryTools.printTreeInfo(root, out, "  ");
        }
        catch (InvalidRegistryException e) {
            out.println("Exception accessing registry :");
            e.printStackTrace(out);
        }
    }

    private static void printTreeInfo(XRegistryKey key, PrintWriter out, String margin) throws InvalidRegistryException {
        String[] subKeys = key.getKeyNames();
        if (subKeys == null || subKeys.length == 0) {
            return;
        }
        for (int i = 0; i < subKeys.length; ++i) {
            RegistryTools.printKeyInfo(key, subKeys[i], out, margin);
            XRegistryKey subKey = key.openKey(RegistryTools.getShortKeyName(subKeys[i]));
            RegistryTools.printTreeInfo(subKey, out, margin + "  ");
            subKey.closeKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printKeyInfo(XRegistryKey parentKey, String keyName, PrintWriter out, String margin) throws InvalidRegistryException {
        out.print(margin);
        keyName = RegistryTools.getShortKeyName(keyName);
        XRegistryKey key = parentKey.openKey(keyName);
        if (key == null) {
            out.println("(null)");
            return;
        }
        out.print("/" + RegistryTools.getShortKeyName(key.getKeyName()) + " ");
        if (!key.isValid()) {
            out.println("(not valid)");
            return;
        }
        if (key.isReadOnly()) {
            out.print("(read only) ");
        }
        if (parentKey.getKeyType(keyName) == RegistryKeyType.LINK) {
            out.println("(link to " + parentKey.getLinkTarget(keyName) + ")");
            return;
        }
        try {
            RegistryValueType type = key.getValueType();
            if (type.equals(RegistryValueType.ASCII)) {
                out.println("[ASCII] = '" + key.getAsciiValue() + "'");
            } else if (type.equals(RegistryValueType.STRING)) {
                out.println("[STRING] = '" + key.getStringValue() + "'");
            } else if (type.equals(RegistryValueType.LONG)) {
                out.println("[LONG] = " + key.getLongValue());
            } else if (type.equals(RegistryValueType.BINARY)) {
                out.print("[BINARY] = {");
                byte[] bin = key.getBinaryValue();
                for (int i = 0; i < bin.length; ++i) {
                    out.print("" + bin[i] + ",");
                }
                out.println("}");
            } else if (type.equals(RegistryValueType.ASCIILIST)) {
                out.print("[ASCIILIST] = {");
                String[] list = key.getAsciiListValue();
                for (int i = 0; i < list.length; ++i) {
                    out.print("'" + list[i] + "',");
                }
                out.println("}");
            } else if (type.equals(RegistryValueType.STRINGLIST)) {
                out.print("[STRINGLIST] = {");
                String[] list = key.getStringListValue();
                for (int i = 0; i < list.length; ++i) {
                    out.print("'" + list[i] + "',");
                }
                out.println("}");
            } else if (type.equals(RegistryValueType.LONGLIST)) {
                out.print("[LONGLIST] = {");
                int[] list = key.getLongListValue();
                for (int i = 0; i < list.length; ++i) {
                    out.print("" + list[i] + ",");
                }
                out.println("}");
            } else {
                out.println("");
            }
        }
        catch (Exception e) {
            out.println("Exception occured : ");
            e.printStackTrace(out);
        }
        finally {
            key.closeKey();
        }
    }
}

