/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.awt.XControlModel;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexContainer;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.form.XForm;
import com.sun.star.form.XFormsSupplier;
import com.sun.star.form.XLoadable;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import util.DrawTools;
import util.WriterTools;

public class FormTools {
    public static XControlShape createControlShape(XComponent oDoc, int height, int width, int x, int y, String kind) {
        Size size = new Size();
        Point position = new Point();
        XControlShape oCShape = null;
        XControlModel aControl = null;
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oDoc);
        try {
            Object oInt = oDocMSF.createInstance("com.sun.star.drawing.ControlShape");
            Object aCon = oDocMSF.createInstance("com.sun.star.form.component." + kind);
            XPropertySet model_props = UnoRuntime.queryInterface(XPropertySet.class, aCon);
            model_props.setPropertyValue("DefaultControl", "com.sun.star.form.control." + kind);
            aControl = UnoRuntime.queryInterface(XControlModel.class, aCon);
            oCShape = UnoRuntime.queryInterface(XControlShape.class, oInt);
            size.Height = height;
            size.Width = width;
            position.X = x;
            position.Y = y;
            oCShape.setSize(size);
            oCShape.setPosition(position);
        }
        catch (com.sun.star.uno.Exception e) {
            System.out.println("Couldn't create instance " + e);
        }
        oCShape.setControl(aControl);
        return oCShape;
    }

    public static XControlShape createUnoControlShape(XComponent oDoc, int height, int width, int x, int y, String kind, String defControl) {
        Size size = new Size();
        Point position = new Point();
        XControlShape oCShape = null;
        XControlModel aControl = null;
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oDoc);
        try {
            Object oInt = oDocMSF.createInstance("com.sun.star.drawing.ControlShape");
            Object aCon = oDocMSF.createInstance("com.sun.star.form.component." + kind);
            XPropertySet model_props = UnoRuntime.queryInterface(XPropertySet.class, aCon);
            model_props.setPropertyValue("DefaultControl", "com.sun.star.awt." + defControl);
            aControl = UnoRuntime.queryInterface(XControlModel.class, aCon);
            oCShape = UnoRuntime.queryInterface(XControlShape.class, oInt);
            size.Height = height;
            size.Width = width;
            position.X = x;
            position.Y = y;
            oCShape.setSize(size);
            oCShape.setPosition(position);
        }
        catch (com.sun.star.uno.Exception e) {
            System.out.println("Couldn't create instance " + e);
        }
        oCShape.setControl(aControl);
        return oCShape;
    }

    public static XControlShape createControlShapeWithDefaultControl(XComponent oDoc, int height, int width, int x, int y, String kind) {
        Size size = new Size();
        Point position = new Point();
        XControlShape oCShape = null;
        XControlModel aControl = null;
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oDoc);
        try {
            Object oInt = oDocMSF.createInstance("com.sun.star.drawing.ControlShape");
            Object aCon = oDocMSF.createInstance("com.sun.star.form.component." + kind);
            aControl = UnoRuntime.queryInterface(XControlModel.class, aCon);
            oCShape = UnoRuntime.queryInterface(XControlShape.class, oInt);
            size.Height = height;
            size.Width = width;
            position.X = x;
            position.Y = y;
            oCShape.setSize(size);
            oCShape.setPosition(position);
        }
        catch (com.sun.star.uno.Exception e) {
            System.out.println("Couldn't create instance " + e);
        }
        oCShape.setControl(aControl);
        return oCShape;
    }

    public static XInterface createControl(XComponent oDoc, String kind) {
        XInterface oControl = null;
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oDoc);
        try {
            oControl = (XInterface)oDocMSF.createInstance("com.sun.star.form.component." + kind);
        }
        catch (Exception e) {
            System.out.println("Couldn't create instance " + kind + ": " + e);
        }
        return oControl;
    }

    public static XNameContainer getForms(XDrawPage oDP) {
        XFormsSupplier oFS = UnoRuntime.queryInterface(XFormsSupplier.class, (Object)oDP);
        return oFS.getForms();
    }

    public static XIndexContainer getIndexedForms(XDrawPage oDP) {
        XFormsSupplier oFS = UnoRuntime.queryInterface(XFormsSupplier.class, (Object)oDP);
        return UnoRuntime.queryInterface(XIndexContainer.class, (Object)oFS.getForms());
    }

    public static void insertForm(XComponent aDoc, XNameContainer Forms, String aName) {
        try {
            XInterface oControl = FormTools.createControl(aDoc, "Form");
            XForm oForm = UnoRuntime.queryInterface(XForm.class, (Object)oControl);
            Forms.insertByName(aName, oForm);
        }
        catch (Exception e) {
            throw new java.lang.IllegalArgumentException("Couldn't insert Form");
        }
    }

    public static XControlShape insertControlShape(XComponent oDoc, int height, int width, int x, int y, String kind) {
        XControlShape aShape = FormTools.createControlShape(oDoc, height, width, x, y, kind);
        XDrawPage oDP = DrawTools.getDrawPage(oDoc, 0);
        DrawTools.getShapes(oDP).add(aShape);
        return aShape;
    }

    public static XLoadable bindForm(XTextDocument aDoc) {
        XLoadable formLoader = null;
        try {
            Object aForm = FormTools.getIndexedForms(WriterTools.getDrawPage(aDoc)).getByIndex(0);
            XForm the_form = null;
            try {
                the_form = (XForm)AnyConverter.toObject((Type)new Type(XForm.class), (Object)aForm);
            }
            catch (IllegalArgumentException iae) {
                System.out.println("### Couldn't convert Any");
            }
            XPropertySet formProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)the_form);
            formProps.setPropertyValue("DataSourceName", "Bibliography");
            formProps.setPropertyValue("Command", "biblio");
            formProps.setPropertyValue("CommandType", new Integer(0));
            formLoader = UnoRuntime.queryInterface(XLoadable.class, (Object)the_form);
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex);
            ex.printStackTrace(System.out);
        }
        return formLoader;
    }

    public static XLoadable bindForm(XTextDocument aDoc, String sourceName, String tableName) throws com.sun.star.uno.Exception {
        XForm the_form = (XForm)AnyConverter.toObject((Type)new Type(XForm.class), (Object)FormTools.getIndexedForms(WriterTools.getDrawPage(aDoc)).getByIndex(0));
        XPropertySet formProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)the_form);
        formProps.setPropertyValue("DataSourceName", sourceName);
        formProps.setPropertyValue("Command", tableName);
        formProps.setPropertyValue("CommandType", new Integer(0));
        return UnoRuntime.queryInterface(XLoadable.class, (Object)the_form);
    }

    public static XLoadable bindForm(XTextDocument aDoc, String formName) {
        XLoadable formLoader = null;
        try {
            XForm the_form = (XForm)FormTools.getForms(WriterTools.getDrawPage(aDoc)).getByName(formName);
            XPropertySet formProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)the_form);
            formProps.setPropertyValue("DataSourceName", "Bibliography");
            formProps.setPropertyValue("Command", "biblio");
            formProps.setPropertyValue("CommandType", new Integer(0));
            formLoader = UnoRuntime.queryInterface(XLoadable.class, (Object)the_form);
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex);
            ex.printStackTrace(System.out);
        }
        return formLoader;
    }

    public static XLoadable bindForm(XTextDocument aDoc, String formName, String sourceName, String tableName) throws com.sun.star.uno.Exception {
        XForm the_form = (XForm)AnyConverter.toObject((Type)new Type(XForm.class), (Object)FormTools.getForms(WriterTools.getDrawPage(aDoc)).getByName(formName));
        XPropertySet formProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)the_form);
        formProps.setPropertyValue("DataSourceName", sourceName);
        formProps.setPropertyValue("Command", tableName);
        formProps.setPropertyValue("CommandType", new Integer(0));
        return UnoRuntime.queryInterface(XLoadable.class, (Object)the_form);
    }

    public static void switchDesignOf(XMultiServiceFactory xMSF, XTextDocument aDoc) {
        try {
            XController aController = aDoc.getCurrentController();
            XFrame aFrame = aController.getFrame();
            XDispatchProvider aDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)aFrame);
            URL aURL = new URL();
            aURL.Complete = ".uno:SwitchControlDesignMode";
            Object instance = xMSF.createInstance("com.sun.star.util.URLTransformer");
            XURLTransformer atrans = UnoRuntime.queryInterface(XURLTransformer.class, instance);
            URL[] aURLA = new URL[]{aURL};
            atrans.parseStrict(aURLA);
            aURL = aURLA[0];
            XDispatch aDisp = aDispProv.queryDispatch(aURL, "", 6);
            PropertyValue[] noArgs = new PropertyValue[]{};
            aDisp.dispatch(aURL, noArgs);
        }
        catch (Exception e) {
            System.out.println("******* Mist");
            e.printStackTrace();
        }
    }
}

