/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class DynamicClassLoader {
    public static Class forName(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public Object getInstance(String className) throws IllegalArgumentException {
        try {
            Class cls = DynamicClassLoader.forName(className);
            return cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Couldn't find " + className + " " + e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Couldn't access " + className + " " + e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Couldn't instantiate " + className + " " + e);
        }
    }

    public Object getInstance(String className, Object[] ctorArgs) throws IllegalArgumentException {
        Class[] ctorType = new Class[ctorArgs.length];
        for (int i = 0; i < ctorType.length; ++i) {
            ctorType[i] = ctorArgs[i].getClass();
        }
        return this.getInstance(className, ctorType, ctorArgs);
    }

    public Object getInstance(String className, Class[] ctorClassTypes, Object[] ctorArgs) throws IllegalArgumentException {
        try {
            Class cls = DynamicClassLoader.forName(className);
            Constructor ctor = cls.getConstructor(ctorClassTypes);
            System.out.println("ctor: " + ctor.getName() + "  " + ctor.getModifiers());
            return ctor.newInstance(ctorArgs);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Couldn't find " + className + " " + e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Couldn't access " + className + " " + e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Couldn't find constructor for " + className + " " + e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Couldn't invoke " + className + " " + e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Couldn't instantiate " + className + " " + e);
        }
    }
}

