/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import util.DesktopTools;
import util.InstCreator;
import util.ShapeDsc;

public class DrawTools {
    public static XComponent createDrawDoc(XMultiServiceFactory xMSF) {
        PropertyValue[] Args = new PropertyValue[]{};
        XComponent DrawDoc = DesktopTools.openNewDoc(xMSF, "sdraw", Args);
        return DrawDoc;
    }

    public static XDrawPages getDrawPages(XComponent aDoc) {
        XDrawPages oDPn = null;
        try {
            XDrawPagesSupplier oDPS = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)aDoc);
            oDPn = oDPS.getDrawPages();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't get drawpages");
        }
        return oDPn;
    }

    public static XDrawPage getDrawPage(XComponent aDoc, int nr) {
        XDrawPage oDP = null;
        try {
            oDP = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)DrawTools.getDrawPages(aDoc).getByIndex(nr));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't get drawpage");
        }
        return oDP;
    }

    public static XShapes getShapes(XDrawPage oDP) {
        return UnoRuntime.queryInterface(XShapes.class, (Object)oDP);
    }

    public XShape createShape(XComponent oDoc, int height, int width, int x, int y, String kind) {
        ShapeDsc sDsc = new ShapeDsc(height, width, x, y, kind);
        InstCreator instCreate = new InstCreator(oDoc, sDsc);
        XShape oShape = (XShape)instCreate.getInstance();
        return oShape;
    }

    public void addShape(XComponent oDoc, int height, int width, int x, int y, String kind) {
        DrawTools.getShapes(DrawTools.getDrawPage(oDoc, 0)).add(this.createShape(oDoc, height, width, x, y, kind));
    }
}

