/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XNameReplace;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XModifiable;
import com.sun.star.view.XViewSettingsSupplier;
import helper.ConfigHelper;
import java.util.Vector;
import lib.StatusException;
import util.utils;

public class DesktopTools {
    public static XComponentLoader getCLoader(XMultiServiceFactory xMSF) {
        XDesktop oDesktop = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop(xMSF));
        XComponentLoader oCLoader = UnoRuntime.queryInterface(XComponentLoader.class, (Object)oDesktop);
        return oCLoader;
    }

    public static Object createDesktop(XMultiServiceFactory xMSF) {
        Object oInterface;
        try {
            oInterface = xMSF.createInstance("com.sun.star.comp.framework.Desktop");
        }
        catch (com.sun.star.uno.Exception e) {
            throw new java.lang.IllegalArgumentException("Desktop Service not available");
        }
        return oInterface;
    }

    public static XEnumeration getAllComponents(XMultiServiceFactory xMSF) {
        XDesktop xDesktop = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop(xMSF));
        return xDesktop.getComponents().createEnumeration();
    }

    public static XComponent getCurrentComponent(XMultiServiceFactory xMSF) {
        XDesktop xDesktop = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop(xMSF));
        return xDesktop.getCurrentComponent();
    }

    public static XFrame getCurrentFrame(XMultiServiceFactory xMSF) {
        XDesktop xDesktop = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop(xMSF));
        return xDesktop.getCurrentFrame();
    }

    public static Object[] getAllOpenDocuments(XMultiServiceFactory xMSF) {
        Vector<XComponent> components = new Vector<XComponent>();
        XDesktop xDesktop = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop(xMSF));
        XEnumeration allComp = DesktopTools.getAllComponents(xMSF);
        while (allComp.hasMoreElements()) {
            try {
                XComponent xComponent = UnoRuntime.queryInterface(XComponent.class, allComp.nextElement());
                if (DesktopTools.getDocumentType(xComponent) == null) continue;
                components.add(xComponent);
            }
            catch (NoSuchElementException e) {
            }
            catch (WrappedTargetException e) {}
        }
        return components.toArray();
    }

    public static String getDocumentType(XComponent xComponent) {
        XServiceInfo sInfo = UnoRuntime.queryInterface(XServiceInfo.class, (Object)xComponent);
        if (sInfo == null) {
            return "";
        }
        if (sInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument")) {
            return "scalc";
        }
        if (sInfo.supportsService("com.sun.star.text.TextDocument")) {
            return "swriter";
        }
        if (sInfo.supportsService("com.sun.star.drawing.DrawingDocument")) {
            return "sdraw";
        }
        if (sInfo.supportsService("com.sun.star.presentation.PresentationDocument")) {
            return "simpress";
        }
        if (sInfo.supportsService("com.sun.star.formula.FormulaProperties")) {
            return "smath";
        }
        return null;
    }

    public static XComponent openNewDoc(XMultiServiceFactory xMSF, String kind, PropertyValue[] Args) {
        XComponent oDoc = null;
        try {
            oDoc = DesktopTools.getCLoader(xMSF).loadComponentFromURL("private:factory/" + kind, "_blank", 0, Args);
        }
        catch (com.sun.star.uno.Exception e) {
            throw new java.lang.IllegalArgumentException("Document could not be opened");
        }
        return oDoc;
    }

    public static XComponent loadDoc(XMultiServiceFactory xMSF, String url, PropertyValue[] Args) {
        XComponent oDoc = null;
        if (Args == null) {
            Args = new PropertyValue[]{};
        }
        try {
            oDoc = DesktopTools.getCLoader(xMSF).loadComponentFromURL(url, "_blank", 0, Args);
        }
        catch (com.sun.star.uno.Exception e) {
            throw new java.lang.IllegalArgumentException("Document could not be loaded");
        }
        DesktopTools.bringWindowToFront(oDoc);
        return oDoc;
    }

    public static void closeDoc(XInterface DocumentToClose) {
        if (DocumentToClose == null) {
            return;
        }
        String kd = System.getProperty("KeepDocument");
        if (kd != null) {
            System.out.println("The property 'KeepDocument' is set and so the document won't be disposed");
            return;
        }
        XModifiable modified = UnoRuntime.queryInterface(XModifiable.class, (Object)DocumentToClose);
        XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)DocumentToClose);
        try {
            if (modified != null) {
                modified.setModified(false);
            }
            closer.close(true);
        }
        catch (CloseVetoException e) {
            System.out.println("Couldn't close document");
        }
        catch (DisposedException e) {
            System.out.println("Couldn't close document");
        }
        catch (NullPointerException e) {
            System.out.println("Couldn't close document");
        }
        catch (PropertyVetoException e) {
            System.out.println("Couldn't close document");
        }
    }

    public static XWindowPeer createFloatingWindow(XMultiServiceFactory xMSF) throws StatusException {
        return DesktopTools.createFloatingWindow(xMSF, 500, 100, 400, 600);
    }

    public static XWindowPeer createFloatingWindow(XMultiServiceFactory xMSF, int X, int Y, int width, int height) throws StatusException {
        XInterface oObj = null;
        try {
            oObj = (XInterface)xMSF.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (com.sun.star.uno.Exception e) {
            throw new StatusException("Couldn't get toolkit", e);
        }
        XToolkit tk = UnoRuntime.queryInterface(XToolkit.class, (Object)oObj);
        WindowDescriptor descriptor = new WindowDescriptor();
        descriptor.Type = WindowClass.TOP;
        descriptor.WindowServiceName = "modelessdialog";
        descriptor.ParentIndex = (short)-1;
        Rectangle bounds = new Rectangle();
        bounds.X = X;
        bounds.Y = Y;
        bounds.Width = width;
        bounds.Height = height;
        descriptor.Bounds = bounds;
        descriptor.WindowAttributes = 524528;
        XWindowPeer xWindow = null;
        try {
            xWindow = tk.createWindow(descriptor);
        }
        catch (IllegalArgumentException e) {
            throw new StatusException("Could not create window", e);
        }
        return xWindow;
    }

    public static void zoomToEntirePage(XInterface xDoc) {
        try {
            XModel xMod = UnoRuntime.queryInterface(XModel.class, (Object)xDoc);
            XController oCont = xMod.getCurrentController();
            XViewSettingsSupplier oVSSupp = UnoRuntime.queryInterface(XViewSettingsSupplier.class, (Object)oCont);
            XPropertySet oViewSettings = oVSSupp.getViewSettings();
            XPropertySet oViewProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)oViewSettings);
            oViewProp.setPropertyValue("ZoomType", new Short(2));
            utils.shortWait(5000);
        }
        catch (Exception e) {
            System.out.println("Could not zoom to entire page: " + e.toString());
        }
    }

    public static void dockStylist(XMultiServiceFactory xMSF) {
        try {
            ConfigHelper aConfig = new ConfigHelper(xMSF, "org.openoffice.Office.Views", false);
            XNameReplace x5539 = aConfig.getOrInsertGroup("Windows", "5539");
            aConfig.updateGroupProperty("Windows", "5539", "WindowState", "952,180,244,349;1;0,0,0,0;");
            aConfig.insertOrUpdateExtensibleGroupProperty("Windows", "5539", "UserData", "Data", "V2,V,0,AL:(5,16,0/0/244/349,244;610)");
            aConfig.getOrInsertGroup("Windows", "SplitWindow2");
            aConfig.insertOrUpdateExtensibleGroupProperty("Windows", "SplitWindow2", "UserData", "UserItem", "V1,2,1,0,5539");
            aConfig.flush();
            aConfig = null;
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static void bringWindowToFromt(XModel xModel) {
        DesktopTools.bringWindowToFront(xModel);
    }

    public static void bringWindowToFront(XModel xModel) {
        XTopWindow xTopWindow = UnoRuntime.queryInterface(XTopWindow.class, (Object)xModel.getCurrentController().getFrame().getContainerWindow());
        xTopWindow.toFront();
    }

    public static void bringWindowToFront(XComponent xComponent) {
        XModel xModel = UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
        if (xModel != null) {
            DesktopTools.bringWindowToFront(xModel);
        }
    }
}

