/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XStorable;
import com.sun.star.io.XDataInputStream;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XTextInputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XCompletedConnection;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XCloseable;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XResultSetUpdate;
import com.sun.star.sdbc.XRowUpdate;
import com.sun.star.sdbc.XStatement;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;
import com.sun.star.util.Date;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import util.utils;

public class DBTools {
    private XMultiServiceFactory xMSF = null;
    private XNamingService dbContext = null;
    public static final String TST_JDBC_DRIVER = "org.gjt.mm.mysql.Driver";
    public static final int TST_STRING = 1;
    public static final int TST_INT = 2;
    public static final int TST_DOUBLE = 5;
    public static final int TST_DATE = 6;
    public static final int TST_BOOLEAN = 10;
    public static final int TST_CHARACTER_STREAM = 11;
    public static final int TST_BINARY_STREAM = 12;
    public static final String TST_STRING_F = "_TEXT";
    public static final String TST_INT_F = "_INT";
    public static final String TST_DOUBLE_F = "_DOUBLE";
    public static final String TST_DATE_F = "_DATE";
    public static final String TST_BOOLEAN_F = "_BOOL";
    public static final String TST_CHARACTER_STREAM_F = "_MEMO1";
    public static final String TST_BINARY_STREAM_F = "_MEMO2";
    public static final Object[][] TST_TABLE_VALUES = new Object[][]{{"String1", new Integer(1), null, null, new Double(1.1), new Date(1, 1, 2001), null, null, null, Boolean.TRUE, null, null}, {"String2", new Integer(2), null, null, new Double(1.2), new Date(2, 1, 2001), null, null, null, Boolean.FALSE, null, null}, {null, null, null, null, null, null, null, null, null, null, null, null}};
    public static final int[] TST_STREAM_LENGTHS = new int[]{0, 0, 0};

    public DBTools(XMultiServiceFactory xMSF) {
        this.xMSF = xMSF;
        try {
            Object cont = xMSF.createInstance("com.sun.star.sdb.DatabaseContext");
            this.dbContext = UnoRuntime.queryInterface(XNamingService.class, cont);
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
    }

    public DataSourceInfo newDataSourceInfo() {
        return new DataSourceInfo();
    }

    public DataSourceInfo newDataSourceInfo(Object dataSource) {
        return new DataSourceInfo(dataSource);
    }

    public void registerDB(String name, Object dataSource) throws com.sun.star.uno.Exception {
        this.dbContext.registerObject(name, dataSource);
    }

    public void reRegisterDB(String name, Object dataSource) throws com.sun.star.uno.Exception {
        try {
            this.revokeDB(name);
        }
        catch (com.sun.star.uno.Exception e) {
            // empty catch block
        }
        XDocumentDataSource xDDS = UnoRuntime.queryInterface(XDocumentDataSource.class, dataSource);
        XStorable store = UnoRuntime.queryInterface(XStorable.class, (Object)xDDS.getDatabaseDocument());
        String aFile = utils.getOfficeTemp(this.xMSF) + name + ".odb";
        store.storeAsURL(aFile, new PropertyValue[0]);
        this.registerDB(name, dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XConnection connectToTextDB(String contextName, String dbDir, String fileExtension) throws com.sun.star.uno.Exception {
        try {
            XConnection con;
            XInterface newSource = (XInterface)this.xMSF.createInstance("com.sun.star.sdb.DataSource");
            XPropertySet xSrcProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)newSource);
            xSrcProp.setPropertyValue("URL", "sdbc:text:" + DBTools.dirToUrl(dbDir));
            PropertyValue extParam = new PropertyValue();
            extParam.Name = "EXT";
            extParam.Value = fileExtension;
            xSrcProp.setPropertyValue("Info", new PropertyValue[]{extParam});
            this.dbContext.registerObject(contextName, newSource);
            Object handler = this.xMSF.createInstance("com.sun.star.sdb.InteractionHandler");
            XInteractionHandler xHandler = UnoRuntime.queryInterface(XInteractionHandler.class, handler);
            XCompletedConnection xSrcCon = UnoRuntime.queryInterface(XCompletedConnection.class, (Object)newSource);
            XConnection xConnection = con = xSrcCon.connectWithCompletion(xHandler);
            return xConnection;
        }
        finally {
            try {
                this.dbContext.revokeObject(contextName);
            }
            catch (Exception e) {}
        }
    }

    public XConnection connectToDBase(String contextName, String dbDir) throws com.sun.star.uno.Exception {
        try {
            XInterface newSource = (XInterface)this.xMSF.createInstance("com.sun.star.sdb.DataSource");
            XPropertySet xSrcProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)newSource);
            xSrcProp.setPropertyValue("URL", "sdbc:dbase:" + DBTools.dirToUrl(dbDir));
            this.dbContext.registerObject(contextName, newSource);
            XConnection con = this.connectToSource(newSource);
            return con;
        }
        catch (com.sun.star.uno.Exception e) {
            try {
                this.dbContext.revokeObject(contextName);
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw e;
        }
    }

    public XConnection connectToSource(Object dbSource) throws com.sun.star.uno.Exception {
        Object handler = this.xMSF.createInstance("com.sun.star.sdb.InteractionHandler");
        XInteractionHandler xHandler = UnoRuntime.queryInterface(XInteractionHandler.class, handler);
        XCompletedConnection xSrcCon = UnoRuntime.queryInterface(XCompletedConnection.class, dbSource);
        return xSrcCon.connectWithCompletion(xHandler);
    }

    public Object registerTestDB(String docPath) throws com.sun.star.uno.Exception {
        String testURL = null;
        testURL = docPath.endsWith("/") || docPath.endsWith("\\") ? DBTools.dirToUrl(docPath + "TestDB") : DBTools.dirToUrl(docPath + "/" + "TestDB");
        testURL = "sdbc:dbase:" + testURL;
        String existURL = null;
        XNameAccess na = UnoRuntime.queryInterface(XNameAccess.class, (Object)this.dbContext);
        Object src = null;
        if (na.hasByName("APITestDatabase")) {
            src = this.dbContext.getRegisteredObject("APITestDatabase");
            XPropertySet srcPs = UnoRuntime.queryInterface(XPropertySet.class, src);
            existURL = (String)srcPs.getPropertyValue("URL");
        }
        if (src == null || !testURL.equals(existURL)) {
            DataSourceInfo info = new DataSourceInfo();
            info.URL = testURL;
            src = info.getDataSourceService();
            this.reRegisterDB("APITestDatabase", src);
            src = this.dbContext.getRegisteredObject("APITestDatabase");
        }
        return src;
    }

    public XConnection connectToTestDB(String docPath) throws com.sun.star.uno.Exception {
        return this.connectToSource(this.registerTestDB(docPath));
    }

    public int deleteAllRows(XConnection con, String table) throws SQLException {
        XStatement stat = con.createStatement();
        XResultSet set = stat.executeQuery("SELECT * FROM " + table);
        XResultSetUpdate updt = UnoRuntime.queryInterface(XResultSetUpdate.class, (Object)set);
        int count = 0;
        set.last();
        int rowNum = set.getRow();
        set.first();
        for (int i = 0; i < rowNum; ++i) {
            updt.deleteRow();
            set.next();
            ++count;
        }
        XCloseable xClose = UnoRuntime.queryInterface(XCloseable.class, (Object)set);
        xClose.close();
        return count;
    }

    public void addRowToTestTable(XConnection con, String table, Object[] values, int streamLength) throws SQLException {
        XStatement stat = con.createStatement();
        XResultSet set = stat.executeQuery("SELECT * FROM " + table);
        XResultSetUpdate updt = UnoRuntime.queryInterface(XResultSetUpdate.class, (Object)set);
        XRowUpdate rowUpdt = UnoRuntime.queryInterface(XRowUpdate.class, (Object)set);
        updt.moveToInsertRow();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof String) {
                rowUpdt.updateString(1, (String)values[i]);
                continue;
            }
            if (values[i] instanceof Integer) {
                rowUpdt.updateInt(2, (Integer)values[i]);
                continue;
            }
            if (values[i] instanceof Double) {
                rowUpdt.updateDouble(5, (Double)values[i]);
                continue;
            }
            if (values[i] instanceof Date) {
                rowUpdt.updateDate(6, (Date)values[i]);
                continue;
            }
            if (values[i] instanceof Boolean) {
                rowUpdt.updateBoolean(10, (Boolean)values[i]);
                continue;
            }
            if (values[i] instanceof XTextInputStream) {
                rowUpdt.updateCharacterStream(11, (XInputStream)values[i], streamLength);
                continue;
            }
            if (!(values[i] instanceof XDataInputStream)) continue;
            rowUpdt.updateBinaryStream(12, (XInputStream)values[i], streamLength);
        }
        updt.insertRow();
        XCloseable xClose = UnoRuntime.queryInterface(XCloseable.class, (Object)set);
        xClose.close();
    }

    public void initializeTestTable(XConnection con, String table) throws SQLException {
        this.deleteAllRows(con, table);
        for (int i = 0; i < TST_TABLE_VALUES.length; ++i) {
            this.addRowToTestTable(con, table, TST_TABLE_VALUES[i], TST_STREAM_LENGTHS[i]);
        }
    }

    public void printRegisteredDatabasesInfo(PrintWriter out) {
        XEnumerationAccess dbContEA = UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)this.dbContext);
        XEnumeration xEnum = dbContEA.createEnumeration();
        out.println("DatabaseContext registered DataSource's :");
        while (xEnum.hasMoreElements()) {
            try {
                DataSourceInfo inf = new DataSourceInfo(xEnum.nextElement());
                inf.printInfo(out);
            }
            catch (NoSuchElementException e) {
            }
            catch (WrappedTargetException e) {}
        }
    }

    public static String dirToUrl(String dir) {
        String retVal = null;
        if (dir.startsWith("file:/")) {
            retVal = dir;
        } else {
            retVal = dir.replace(':', '|').replace('\\', '/');
            retVal = dir.startsWith("\\\\") ? "file:" + retVal : "file:///" + retVal;
        }
        return retVal;
    }

    public void revokeDB(String name) throws com.sun.star.uno.Exception {
        this.dbContext.revokeObject(name);
    }

    public void initTestTableUsingJDBC(String tbl_name, DataSourceInfo dsi) throws java.sql.SQLException, ClassNotFoundException {
        if (dsi.Info[0].Name.equals("JavaDriverClass")) {
            Class.forName((String)dsi.Info[0].Value);
        } else {
            Class.forName(TST_JDBC_DRIVER);
        }
        Connection connection = null;
        connection = DriverManager.getConnection(dsi.URL, dsi.User, dsi.Password);
        Statement statement = connection.createStatement();
        this.dropMySQLTable(statement, tbl_name);
        this.createMySQLTable(statement, tbl_name);
        this.insertContentMySQLTable(statement, tbl_name);
    }

    protected void insertContentMySQLTable(Statement statement, String tbl_name) throws java.sql.SQLException {
        for (int i = 0; i < TST_TABLE_VALUES.length; ++i) {
            String query = "insert into " + tbl_name + " values (";
            for (int j = 0; j < TST_TABLE_VALUES[i].length; ++j) {
                Object value;
                if (j > 0) {
                    query = query + ", ";
                }
                if ((value = TST_TABLE_VALUES[i][j]) instanceof String || value instanceof Date) {
                    query = query + "'";
                }
                if (value instanceof Date) {
                    Date date = (Date)value;
                    query = query + date.Year + "-" + date.Month + "-" + date.Day;
                } else {
                    query = value instanceof Boolean ? query + ((Boolean)value != false ? "1" : "0") : query + value;
                }
                if (!(value instanceof String) && !(value instanceof Date)) continue;
                query = query + "'";
            }
            query = query + ")";
            statement.executeUpdate(query);
        }
    }

    protected void createMySQLTable(Statement statement, String tbl_name) throws java.sql.SQLException {
        String empty_col_name = "Column";
        int c = 0;
        String query = "create table " + tbl_name + " (";
        block9: for (int i = 0; i < TST_TABLE_VALUES[0].length; ++i) {
            if (i > 0) {
                query = query + ",";
            }
            switch (i + 1) {
                case 12: {
                    query = query + "_MEMO2 BLOB";
                    continue block9;
                }
                case 10: {
                    query = query + "_BOOL TINYINT";
                    continue block9;
                }
                case 11: {
                    query = query + "_MEMO1 TEXT";
                    continue block9;
                }
                case 6: {
                    query = query + "_DATE DATE";
                    continue block9;
                }
                case 5: {
                    query = query + "_DOUBLE DOUBLE";
                    continue block9;
                }
                case 2: {
                    query = query + "_INT INT";
                    continue block9;
                }
                case 1: {
                    query = query + "_TEXT TEXT";
                    continue block9;
                }
                default: {
                    query = query + "Column" + c++ + " INT";
                    if (c != 1) continue block9;
                    query = query + " NOT NULL AUTO_INCREMENT";
                }
            }
        }
        query = query + ", PRIMARY KEY (Column0)";
        query = query + ")";
        statement.execute(query);
    }

    protected void dropMySQLTable(Statement statement, String tbl_name) throws java.sql.SQLException {
        statement.executeUpdate("drop table if exists " + tbl_name);
    }

    public class DataSourceInfo {
        public String Name = null;
        public String URL = null;
        public PropertyValue[] Info = null;
        public String User = null;
        public String Password = null;
        public Boolean IsPasswordRequired = null;
        public Boolean SuppressVersionColumns = null;
        public Boolean IsReadOnly = null;
        public String[] TableFilter = null;
        public String[] TableTypeFilter = null;

        public DataSourceInfo() {
        }

        public DataSourceInfo(Object dataSource) {
            XPropertySet xProps = UnoRuntime.queryInterface(XPropertySet.class, dataSource);
            try {
                this.Name = (String)xProps.getPropertyValue("Name");
                this.URL = (String)xProps.getPropertyValue("URL");
                this.Info = (PropertyValue[])xProps.getPropertyValue("Info");
                this.User = (String)xProps.getPropertyValue("User");
                this.Password = (String)xProps.getPropertyValue("Password");
                this.IsPasswordRequired = (Boolean)xProps.getPropertyValue("IsPasswordRequired");
                this.SuppressVersionColumns = (Boolean)xProps.getPropertyValue("SuppressVersionColumns");
                this.IsReadOnly = (Boolean)xProps.getPropertyValue("IsReadOnly");
                this.TableFilter = (String[])xProps.getPropertyValue("TableFilter");
                this.TableTypeFilter = (String[])xProps.getPropertyValue("TableTypeFilter");
            }
            catch (UnknownPropertyException e) {
                System.err.println("util.DBTools.DataSourceInfo: Error retrieving property");
                e.printStackTrace(System.err);
            }
            catch (WrappedTargetException e) {
                System.err.println("util.DBTools.DataSourceInfo: Error retrieving property");
                e.printStackTrace(System.err);
            }
        }

        public void printInfo(PrintWriter out) {
            int i;
            out.println("Name = '" + this.Name + "'");
            out.println("  URL = '" + this.URL + "'");
            out.print("  Info = ");
            if (this.Info == null) {
                out.println("null");
            } else {
                out.print("{");
                for (i = 0; i < this.Info.length; ++i) {
                    out.print(this.Info[i].Name + " = '" + this.Info[i].Value + "'");
                    if (i + 1 >= this.Info.length) continue;
                    out.print("; ");
                }
                out.println("}");
            }
            out.println("  User = '" + this.User + "'");
            out.println("  Password = '" + this.Password + "'");
            out.println("  IsPasswordRequired = '" + this.IsPasswordRequired + "'");
            out.println("  SuppressVersionColumns = '" + this.SuppressVersionColumns + "'");
            out.println("  IsReadOnly = '" + this.IsReadOnly + "'");
            out.print("  TableFilter = ");
            if (this.TableFilter == null) {
                out.println("null");
            } else {
                out.print("{");
                for (i = 0; i < this.TableFilter.length; ++i) {
                    out.print("'" + this.TableFilter[i] + "'");
                    if (i + 1 >= this.TableFilter.length) continue;
                    out.print("; ");
                }
                out.println("}");
            }
            out.print("  TableTypeFilter = ");
            if (this.TableTypeFilter == null) {
                out.println("null");
            } else {
                out.print("{");
                for (i = 0; i < this.TableTypeFilter.length; ++i) {
                    out.print("'" + this.TableTypeFilter[i] + "'");
                    if (i + 1 >= this.TableTypeFilter.length) continue;
                    out.print("; ");
                }
                out.println("}");
            }
        }

        public Object getDataSourceService() {
            Object src = null;
            try {
                src = DBTools.this.xMSF.createInstance("com.sun.star.sdb.DataSource");
            }
            catch (com.sun.star.uno.Exception e) {
                // empty catch block
            }
            if (src == null) {
                return null;
            }
            XPropertySet props = UnoRuntime.queryInterface(XPropertySet.class, src);
            try {
                if (this.Name != null) {
                    props.setPropertyValue("Name", this.Name);
                }
                if (this.URL != null) {
                    props.setPropertyValue("URL", this.URL);
                }
                if (this.Info != null) {
                    props.setPropertyValue("Info", this.Info);
                }
                if (this.User != null) {
                    props.setPropertyValue("User", this.User);
                }
                if (this.Password != null) {
                    props.setPropertyValue("Password", this.Password);
                }
                if (this.IsPasswordRequired != null) {
                    props.setPropertyValue("IsPasswordRequired", this.IsPasswordRequired);
                }
                if (this.SuppressVersionColumns != null) {
                    props.setPropertyValue("SuppressVersionColumns", this.SuppressVersionColumns);
                }
                if (this.IsReadOnly != null) {
                    props.setPropertyValue("IsReadOnly", this.IsReadOnly);
                }
                if (this.TableFilter != null) {
                    props.setPropertyValue("TableFilter", this.TableFilter);
                }
                if (this.TableTypeFilter != null) {
                    props.setPropertyValue("TableTypeFilter", this.TableTypeFilter);
                }
            }
            catch (UnknownPropertyException e) {
                return null;
            }
            catch (PropertyVetoException e) {
                return null;
            }
            catch (WrappedTargetException e) {
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            return src;
        }
    }
}

