/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.XLibraryContainer;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XChangesBatch;
import com.sun.star.util.XURLTransformer;
import util.utils;

public class BasicMacroTools {
    private final XDispatchProvider mDispProv;
    private final XMultiServiceFactory mMSF;
    private final XURLTransformer mParser;
    private final XNameAccess mLCxNA;
    private final XLibraryContainer mLCxLC;

    public BasicMacroTools(XMultiServiceFactory msf, XModel xModel, XComponent xDoc) throws Exception {
        try {
            this.mMSF = msf;
            this.mDispProv = BasicMacroTools.makeDispatchProvider(this.mMSF, xModel);
            this.mParser = BasicMacroTools.makeParser(this.mMSF);
            Object DocLibCont = null;
            try {
                XPropertySet xDocProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)xDoc);
                DocLibCont = xDocProps.getPropertyValue("BasicLibraries");
            }
            catch (com.sun.star.uno.Exception e) {
                throw new Exception("Couldn't get BasicLibraries-Container from document: " + e.toString());
            }
            this.mLCxNA = UnoRuntime.queryInterface(XNameAccess.class, DocLibCont);
            this.mLCxLC = UnoRuntime.queryInterface(XLibraryContainer.class, DocLibCont);
        }
        catch (Exception e) {
            throw new Exception("could not initialize BasicMacros " + e.toString());
        }
    }

    public BasicMacroTools(XMultiServiceFactory msf, XModel xModel) throws Exception {
        try {
            this.mMSF = msf;
            this.mDispProv = BasicMacroTools.makeDispatchProvider(this.mMSF, xModel);
            this.mParser = BasicMacroTools.makeParser(this.mMSF);
            Object ASLC = null;
            try {
                ASLC = this.mMSF.createInstance("com.sun.star.script.ApplicationScriptLibraryContainer");
            }
            catch (com.sun.star.uno.Exception e) {
                throw new Exception("Couldn't create ApplicationScriptLibraryContainer" + e.toString());
            }
            this.mLCxNA = UnoRuntime.queryInterface(XNameAccess.class, ASLC);
            this.mLCxLC = UnoRuntime.queryInterface(XLibraryContainer.class, ASLC);
        }
        catch (Exception e) {
            throw new Exception("could not initialize BasicMacros " + e.toString());
        }
    }

    private static XDispatchProvider makeDispatchProvider(XMultiServiceFactory mMSF, XModel aModel) throws Exception {
        XController xController = aModel.getCurrentController();
        XFrame xFrame = xController.getFrame();
        if (xFrame == null) {
            throw new Exception("Could not create DispatchProvider");
        }
        return UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xFrame);
    }

    private static XURLTransformer makeParser(XMultiServiceFactory mMSF) throws Exception {
        try {
            return UnoRuntime.queryInterface(XURLTransformer.class, mMSF.createInstance("com.sun.star.util.URLTransformer"));
        }
        catch (Exception e) {
            throw new Exception("could not create UTL-Transformer " + e.toString());
        }
    }

    public void loadLibrary(String LibraryName, String LibraryURL) throws Exception {
        try {
            this.appendLibrary(LibraryName, LibraryURL);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("ERROR: Could not append Library " + LibraryName + e.toString());
        }
        try {
            this.mLCxLC.loadLibrary(LibraryName);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            throw new Exception("ERROR: Could not load Library " + LibraryName + e.toString());
        }
        catch (WrappedTargetException e) {
            e.printStackTrace();
            throw new Exception("ERROR: Could not load Library " + LibraryName + e.toString());
        }
    }

    private void appendLibrary(String LibraryName, String LibraryURL) throws Exception {
        try {
            this.removeLibrary(LibraryName);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mLCxLC.createLibraryLink(LibraryName, LibraryURL, false);
        }
        catch (ElementExistException e) {
            e.printStackTrace();
            throw new Exception("ERROR: Library " + LibraryName + "already exist." + e.toString());
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace();
            throw new Exception("Could not link Basic library:" + LibraryName + e.toString());
        }
    }

    public void removeLibrary(String LibraryName) throws Exception {
        if (this.mLCxNA.hasByName(LibraryName)) {
            try {
                this.mLCxLC.removeLibrary(LibraryName);
            }
            catch (NoSuchElementException e) {
                e.printStackTrace();
                throw new Exception("Could not remove Basic library:" + LibraryName + ": Library does not exist" + e.toString());
            }
            catch (WrappedTargetException e) {
                e.printStackTrace();
                throw new Exception("Could not remove Basic library:" + LibraryName + e.toString());
            }
        }
    }

    public void runMarco(String MacroName) throws Exception {
        URL[] aParseURL = new URL[]{new URL()};
        aParseURL[0].Complete = "macro://./" + MacroName;
        this.mParser.parseStrict(aParseURL);
        URL aURL = aParseURL[0];
        XDispatch xDispatcher = this.mDispProv.queryDispatch(aURL, "", 0);
        if (xDispatcher == null) {
            throw new Exception("Could not run Macro " + MacroName);
        }
        xDispatcher.dispatch(aURL, null);
    }

    public static void addSecureBasicMarcosURL(XMultiServiceFactory xMSF, String secureURL) throws Exception {
        secureURL = utils.getFullURL(secureURL);
        Object[] ProvArgs = new PropertyValue[1];
        PropertyValue Arg = new PropertyValue();
        Arg.Name = "nodepath";
        Arg.Value = "/org.openoffice.Office.Common/Security";
        ProvArgs[0] = Arg;
        Object oProvider = xMSF.createInstance("com.sun.star.configuration.ConfigurationProvider");
        XMultiServiceFactory oProviderMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, oProvider);
        Object oSecure = oProviderMSF.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess", ProvArgs);
        XPropertySet oSecureProps = UnoRuntime.queryInterface(XPropertySet.class, oSecure);
        Object oScripting = oSecureProps.getPropertyValue("Scripting");
        XPropertySet oScriptingSettings = UnoRuntime.queryInterface(XPropertySet.class, oScripting);
        oScriptingSettings.setPropertyValue("SecureURL", new String[]{secureURL});
        oScriptingSettings.setPropertyValue("OfficeBasic", new Integer(2));
        XChangesBatch oSecureChange = UnoRuntime.queryInterface(XChangesBatch.class, oSecure);
        oSecureChange.commitChanges();
    }
}

