/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.util.Vector;
import share.DescEntry;

public class Summarizer {
    public void summarizeUp(DescEntry entry) {
        if (entry.State != null && !entry.State.equals("UNKNOWN")) {
            return;
        }
        int count = entry.SubEntryCount;
        int knownIssues = 0;
        Vector<String> failures = new Vector<String>();
        Vector<String> states = new Vector<String>();
        for (int i = 0; i < count; ++i) {
            if (entry.SubEntries[i].State == null) {
                entry.SubEntries[i].State = "PASSED.FAILED";
            }
            if (entry.SubEntries[i].State.equals("known issue")) {
                entry.SubEntries[i].State = "PASSED.OK";
                ++knownIssues;
            }
            if (entry.SubEntries[i].State.endsWith("OK")) continue;
            failures.add(entry.SubEntries[i].entryName);
            states.add(entry.SubEntries[i].State);
        }
        if (failures.size() > 0) {
            String errMsg = "";
            String state = "PASSED.FAILED";
            for (int j = 0; j < failures.size(); ++j) {
                if (states.elementAt(j).equals("not part of the job")) {
                    state = "Not possible since not all Interfaces/Services have been checked";
                    continue;
                }
                errMsg = errMsg + failures.elementAt(j) + " - " + states.elementAt(j) + "\r\n";
            }
            entry.hasErrorMsg = true;
            entry.ErrorMsg = errMsg;
            entry.State = state;
        } else {
            entry.State = entry.EntryType.equals("component") && knownIssues > 0 ? "PASSED(with known issues).OK" : "PASSED.OK";
        }
    }

    public static void summarizeDown(DescEntry entry, String state) {
        if (entry.State == null || entry.State.equals("UNKNOWN")) {
            entry.State = state;
        }
        for (int i = 0; i < entry.SubEntryCount; ++i) {
            Summarizer.summarizeDown(entry.SubEntries[i], entry.State);
        }
    }
}

