/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import share.DescEntry;
import share.LogWriter;
import util.utils;

public class SimpleFileOutProducer
implements LogWriter {
    @Override
    public boolean initialize(DescEntry entry, boolean active) {
        return true;
    }

    @Override
    public void println(String msg) {
    }

    @Override
    public boolean summary(DescEntry entry) {
        try {
            String outpath = (String)entry.UserDefinedParams.get("OutputPath");
            if (outpath == null) {
                System.out.println("## Parameter OutputPath isn't defined using default");
                return this.summary_default(entry);
            }
            String FileName = entry.longName + ".out";
            if (!entry.EntryType.equals("component")) {
                FileName = entry.longName.substring(0, entry.longName.indexOf(":")) + ".out";
            }
            utils.make_Directories("", outpath);
            File outputFile = new File(outpath, FileName);
            FileWriter out = new FileWriter(outputFile.toString(), true);
            String ls = System.getProperty("line.separator");
            String date = new Date().toString();
            String header = "***** State for " + entry.longName + "( " + date + " ) ******";
            out.write(header + ls);
            if (entry.hasErrorMsg) {
                out.write(entry.ErrorMsg + ls);
                out.write("Whole " + entry.EntryType + ": " + entry.State + ls);
            } else {
                out.write("Whole " + entry.EntryType + ": " + entry.State + ls);
            }
            String bottom = "";
            for (int i = 0; i < header.length(); ++i) {
                bottom = bottom + "*";
            }
            out.write(bottom + ls);
            out.write("" + ls);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public boolean summary_default(DescEntry entry) {
        String header = "***** State for " + entry.longName + " ******";
        System.out.println(header);
        if (entry.hasErrorMsg) {
            System.out.println(entry.ErrorMsg);
            System.out.println("Whole " + entry.EntryType + ": " + entry.State);
        } else {
            System.out.println("Whole " + entry.EntryType + ": " + entry.State);
        }
        for (int i = 0; i < header.length(); ++i) {
            System.out.print("*");
        }
        System.out.println("");
        return true;
    }

    @Override
    public Object getWatcher() {
        return null;
    }

    @Override
    public void setWatcher(Object watcher) {
    }
}

