/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.io.PrintWriter;
import java.io.StringWriter;
import share.DescEntry;
import share.LogWriter;

public class InternalLogWriter
extends PrintWriter
implements LogWriter {
    boolean active = true;
    static StringWriter writer = new StringWriter();

    public InternalLogWriter() {
        super(new PrintWriter(writer));
    }

    @Override
    public boolean initialize(DescEntry entry, boolean active) {
        this.active = active;
        return true;
    }

    @Override
    public void println(String msg) {
        if (this.active) {
            super.println(msg);
        }
    }

    @Override
    public void print(String msg) {
        if (this.active) {
            super.print(msg);
        }
    }

    @Override
    public boolean summary(DescEntry entry) {
        String header = "***** State for " + entry.longName + " ******";
        this.println(header);
        if (entry.hasErrorMsg) {
            this.println(entry.ErrorMsg);
            this.println("Whole " + entry.EntryType + ": " + entry.State);
        } else {
            this.println("Whole " + entry.EntryType + ": " + entry.State);
        }
        for (int i = 0; i < header.length(); ++i) {
            this.print("*");
        }
        this.println("");
        return true;
    }

    public String getLog() {
        String message = writer.getBuffer().toString();
        writer = new StringWriter();
        return message;
    }

    @Override
    public Object getWatcher() {
        return null;
    }

    @Override
    public void setWatcher(Object watcher) {
    }
}

