/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import share.DescEntry;
import share.LogWriter;
import share.Watcher;

public class FileLogWriter
extends PrintWriter
implements LogWriter {
    HashMap mFileWriters = null;
    boolean logging = false;
    DescEntry entry = null;
    Watcher ow = null;

    public FileLogWriter() {
        super(System.out);
        GregorianCalendar cal = new GregorianCalendar();
        DecimalFormat dfmt = new DecimalFormat("00");
        super.println("LOG> Log started " + dfmt.format(cal.get(5)) + "." + dfmt.format(cal.get(2)) + "." + dfmt.format(cal.get(1)) + " - " + dfmt.format(cal.get(11)) + ":" + dfmt.format(cal.get(12)) + ":" + dfmt.format(cal.get(13)));
        super.flush();
    }

    @Override
    public boolean initialize(DescEntry entry, boolean logging) {
        this.logging = logging;
        this.entry = entry;
        return true;
    }

    public void addFileLog(String filePath) {
        try {
            if (this.mFileWriters == null) {
                this.mFileWriters = new HashMap();
            }
            this.mFileWriters.put(filePath, new FileWriter(filePath));
        }
        catch (IOException e) {
            e.printStackTrace(this);
        }
    }

    public void removeFileLog(String filePath) {
        if (filePath != null) {
            this.mFileWriters.remove(filePath);
        }
    }

    @Override
    public void println(String msg) {
        this.ow = (Watcher)this.entry.UserDefinedParams.get("Watcher");
        if (this.ow != null) {
            this.ow.ping();
        }
        if (this.logging) {
            super.println("LOG> " + msg);
            super.flush();
            if (this.mFileWriters != null && this.mFileWriters.size() > 0) {
                try {
                    FileWriter fw2 = null;
                    for (FileWriter fw2 : this.mFileWriters.values()) {
                        fw2.write("LOG> " + msg + "\n");
                        fw2.flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(this);
                }
            }
        }
    }

    @Override
    public boolean summary(DescEntry entry) {
        String header = "***** State for " + entry.longName + " ******";
        System.out.println(header);
        if (entry.hasErrorMsg) {
            System.out.println(entry.ErrorMsg);
            System.out.println("Whole " + entry.EntryType + ": " + entry.State);
        } else {
            System.out.println("Whole " + entry.EntryType + ": " + entry.State);
        }
        for (int i = 0; i < header.length(); ++i) {
            System.out.print("*");
        }
        System.out.println("");
        return true;
    }

    @Override
    public Object getWatcher() {
        return this.ow;
    }

    @Override
    public void setWatcher(Object watcher) {
        this.entry.UserDefinedParams.put("Watcher", (Watcher)watcher);
    }
}

