/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Impress;

import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLStylesImporter
extends TestCase {
    XComponent xImpressDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating an impress document");
            this.xImpressDoc = SOF.createImpressDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing document ");
        this.xImpressDoc.dispose();
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        Object oInt = null;
        String impValue = "XMLImporter_test";
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            oInt = xMSF.createInstance("com.sun.star.comp.Impress.XMLStylesImporter");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        oObj = (XInterface)oInt;
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", this.xImpressDoc);
        String[][] xml = new String[][]{{"start", "office:document-styles", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:style", "CDATA", "http://openoffice.org/2000/style", "xmlns:fo", "CDATA", "http://www.w3.org/1999/XSL/Format", "xmlns:table", "CDATA", "http://openoffice.org/2000/table"}, {"start", "office:styles"}, {"start", "style:style", "style:name", "CDATA", "XMLImporter_test", "style:family", "CDATA", "graphics", "style:parent-style-name", "CDATA", "standard"}, {"end", "style:style"}, {"end", "office:styles"}, {"end", "office:document-styles"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        XNameAccess styles = null;
        try {
            XStyleFamiliesSupplier sup = UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)this.xImpressDoc);
            XNameAccess oStyleFamilies = sup.getStyleFamilies();
            Object family = oStyleFamilies.getByName("graphics");
            styles = UnoRuntime.queryInterface(XNameAccess.class, family);
            log.println("Styles before:");
            String[] names = styles.getElementNames();
            for (int i = 0; i < names.length; ++i) {
                log.println("  " + names[i]);
            }
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
        }
        final XNameAccess stylesF = styles;
        final PrintWriter logF = log;
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                logF.println("Styles after:");
                String[] names = stylesF.getElementNames();
                for (int i = 0; i < names.length; ++i) {
                    logF.println("  " + names[i]);
                }
                return stylesF.hasByName("XMLImporter_test");
            }
        });
        return tEnv;
    }
}

