/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Impress;

import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.document.XExporter;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLStylesExporter
extends TestCase {
    XComponent xImpressDoc = null;
    protected static int counter = 0;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating an impress document");
            this.xImpressDoc = SOF.createImpressDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xImpressDoc ");
        this.xImpressDoc.dispose();
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XInterface oObj = null;
        FilterChecker filter = new FilterChecker(log);
        Any arg = new Any(new Type(XDocumentHandler.class), (Object)filter);
        String newName = "NewGraphicsStyle" + counter++;
        filter.addTag(new XMLTools.Tag("office:document-styles"));
        filter.addTag(new XMLTools.Tag("office:styles"));
        filter.addTag(new XMLTools.Tag("style:style", "style:name", newName));
        try {
            oObj = (XInterface)xMSF.createInstanceWithArguments("com.sun.star.comp.Impress.XMLStylesExporter", new Object[]{arg});
            XExporter xEx = UnoRuntime.queryInterface(XExporter.class, (Object)oObj);
            xEx.setSourceDocument(this.xImpressDoc);
            XStyleFamiliesSupplier styleSup = UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)this.xImpressDoc);
            XNameAccess styleFamilies = styleSup.getStyleFamilies();
            String[] styleFamiliesNames = styleFamilies.getElementNames();
            XNameContainer StyleFamilyName = UnoRuntime.queryInterface(XNameContainer.class, styleFamilies.getByName(styleFamiliesNames[0]));
            Object SC = SOF.createInstance(this.xImpressDoc, "com.sun.star.style.Style");
            XStyle StylePage = UnoRuntime.queryInterface(XStyle.class, SC);
            StyleFamilyName.insertByName(newName, StylePage);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        log.println("creating a new environment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"simpress: StarOffice XML (Impress)"}));
        tEnv.addObjRelation("SourceDocument", this.xImpressDoc);
        tEnv.addObjRelation("XFilter.Checker", filter);
        return tEnv;
    }

    protected class FilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter log) {
            super(log, false);
        }

        @Override
        public boolean checkFilter() {
            return this.check();
        }
    }
}

