/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Impress;

import com.sun.star.container.XNameAccess;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLImporter
extends TestCase {
    XComponent xImpressDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating an impress document");
            this.xImpressDoc = SOF.createImpressDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing document ");
        this.xImpressDoc.dispose();
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        Object oInt = null;
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            oInt = xMSF.createInstance("com.sun.star.comp.Impress.XMLImporter");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        oObj = (XInterface)oInt;
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", this.xImpressDoc);
        String impName = "XMLImporter";
        String[][] xml = new String[][]{{"start", "office:document", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:draw", "CDATA", "http://openoffice.org/2000/drawing"}, {"start", "office:body"}, {"start", "draw:page", "draw:name", "CDATA", "XMLImporter"}, {"end", "draw:page"}, {"end", "office:body"}, {"end", "office:document"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        XDrawPagesSupplier drawPagesSupplier = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xImpressDoc);
        XDrawPages drawPages = drawPagesSupplier.getDrawPages();
        final XNameAccess xNamePages = UnoRuntime.queryInterface(XNameAccess.class, (Object)drawPages);
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                return xNamePages.hasByName("XMLImporter");
            }
        });
        return tEnv;
    }
}

