/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Impress;

import com.sun.star.container.XNamed;
import com.sun.star.document.XExporter;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLExporter
extends TestCase {
    XComponent xImpressDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating an impress document");
            this.xImpressDoc = SOF.createImpressDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xImpressDoc ");
        this.xImpressDoc.dispose();
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XInterface oObj = null;
        FilterChecker Filter2 = new FilterChecker(log);
        Any arg = new Any(new Type(XDocumentHandler.class), (Object)Filter2);
        String NAME = "XMLExporter";
        try {
            oObj = (XInterface)xMSF.createInstanceWithArguments("com.sun.star.comp.Impress.XMLExporter", new Object[]{arg});
            XDrawPagesSupplier drawPagesSupplier = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xImpressDoc);
            XDrawPages drawPages = drawPagesSupplier.getDrawPages();
            XDrawPage newDrawPage = drawPages.insertNewByIndex(0);
            XNamed newPageNamed = UnoRuntime.queryInterface(XNamed.class, (Object)newDrawPage);
            newPageNamed.setName("XMLExporter");
            XExporter xEx = UnoRuntime.queryInterface(XExporter.class, (Object)oObj);
            xEx.setSourceDocument(this.xImpressDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        Filter2.addTag(new XMLTools.Tag("office:document"));
        Filter2.addTagEnclosed(new XMLTools.Tag("office:body"), new XMLTools.Tag("office:document"));
        Filter2.addTagEnclosed(new XMLTools.Tag("draw:page", "draw:name", "XMLExporter"), new XMLTools.Tag("office:body"));
        log.println("creating a new environment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"simpress: StarOffice XML (Impress)"}));
        tEnv.addObjRelation("SourceDocument", this.xImpressDoc);
        tEnv.addObjRelation("XFilter.Checker", Filter2);
        return tEnv;
    }

    protected class FilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter log) {
            super(log, true);
        }

        @Override
        public boolean checkFilter() {
            return this.check();
        }
    }
}

