/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Impress;

import com.sun.star.container.XNamed;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLContentImporter
extends TestCase {
    XComponent xImpressDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating an impress document");
            this.xImpressDoc = SOF.createImpressDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing document ");
        this.xImpressDoc.dispose();
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        Object oInt = null;
        String impPageName = "XMLImporterPage";
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            oInt = xMSF.createInstance("com.sun.star.comp.Impress.XMLContentImporter");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        oObj = (XInterface)oInt;
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", this.xImpressDoc);
        String[][] xml = new String[][]{{"start", "office:document", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:presentation", "CDATA", "http://openoffice.org/2000/presentation", "xmlns:svg", "CDATA", "http://openoffice.org/2000/svg", "xmlns:draw", "CDATA", "http://openoffice.org/2000/drawing", "office:class", "CDATA", "presentation", "office:version", "CDATA", "1.0"}, {"start", "office:body"}, {"start", "draw:page", "draw:name", "CDATA", "XMLImporterPage", "draw:master-page-name", "CDATA", "Default"}, {"start", "presentation:notes"}, {"start", "draw:page-thumbnail", "draw:style-name", "CDATA", "gr1", "draw:layer", "CDATA", "layout", "svg:width", "CDATA", "12.768cm", "svg:height", "CDATA", "9.576cm", "svg:x", "CDATA", "4.411cm", "svg:y", "CDATA", "2.794cm", "presentation:class", "CDATA", "page", "draw:page-number", "CDATA", "1"}, {"end", "draw:page-thumbnail"}, {"start", "draw:text-box", "presentation:style-name", "CDATA", "Default-notes", "draw:layer", "CDATA", "layout", "svg:width", "CDATA", "15.021cm", "svg:height", "CDATA", "10.63cm", "svg:x", "CDATA", "3.292cm", "svg:y", "CDATA", "13.299cm", "presentation:class", "CDATA", "notes", "presentation:placeholder", "CDATA", "true"}, {"end", "draw:text-box"}, {"end", "presentation:notes"}, {"end", "draw:page"}, {"end", "office:body"}, {"end", "office:document"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        final PrintWriter logF = log;
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                try {
                    XDrawPagesSupplier xPagesSup = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)XMLContentImporter.this.xImpressDoc);
                    XDrawPages xPages = xPagesSup.getDrawPages();
                    XNamed xPageName = UnoRuntime.queryInterface(XNamed.class, xPages.getByIndex(0));
                    String gName = xPageName.getName();
                    logF.println("Page name returned = '" + gName + "'");
                    return "XMLImporterPage".equals(gName);
                }
                catch (com.sun.star.uno.Exception e) {
                    logF.println("Exception occured while checking filter :");
                    e.printStackTrace(logF);
                    return false;
                }
            }
        });
        return tEnv;
    }
}

