/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Impress;

import com.sun.star.container.XNamed;
import com.sun.star.document.XExporter;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.XMLTools;
import util.utils;

public class XMLContentExporter
extends TestCase {
    XComponent xImpressDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating an impress document");
            this.xImpressDoc = SOF.createImpressDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xImpressDoc ");
        this.xImpressDoc.dispose();
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XInterface oObj = null;
        String expPageName = "XMLContentExporter";
        FilterChecker filter = new FilterChecker(log);
        Any arg = new Any(new Type(XDocumentHandler.class), (Object)filter);
        try {
            oObj = (XInterface)xMSF.createInstanceWithArguments("com.sun.star.comp.Impress.XMLContentExporter", new Object[]{arg});
            XExporter xEx = UnoRuntime.queryInterface(XExporter.class, (Object)oObj);
            xEx.setSourceDocument(this.xImpressDoc);
            XDrawPagesSupplier xPagesSup = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xImpressDoc);
            XDrawPages xPages = xPagesSup.getDrawPages();
            XNamed xPageName = UnoRuntime.queryInterface(XNamed.class, xPages.getByIndex(0));
            xPageName.setName("XMLContentExporter");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        filter.addTag(new XMLTools.Tag("office:document-content"));
        filter.addTagEnclosed(new XMLTools.Tag("office:body"), new XMLTools.Tag("office:document-content"));
        filter.addTagEnclosed(new XMLTools.Tag("draw:page", "draw:name", "XMLContentExporter"), new XMLTools.Tag("office:body"));
        log.println("creating a new environment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"simpress: StarOffice XML (Impress)"}));
        tEnv.addObjRelation("SourceDocument", this.xImpressDoc);
        tEnv.addObjRelation("XFilter.Checker", filter);
        log.println("Implementation Name: " + utils.getImplName(oObj));
        return tEnv;
    }

    protected class FilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter log) {
            super(log, true);
        }

        @Override
        public boolean checkFilter() {
            return this.check();
        }
    }
}

