/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Draw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLSettingsImporter
extends TestCase {
    XComponent xDrawDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a drawdocument");
            this.xDrawDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing document ");
        this.xDrawDoc.dispose();
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        Object oInt = null;
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            oInt = xMSF.createInstance("com.sun.star.comp.Draw.XMLSettingsImporter");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        oObj = (XInterface)oInt;
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", this.xDrawDoc);
        String[][] xml = new String[][]{{"start", "office:document-settings", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:config", "CDATA", "http://openoffice.org/2001/config"}, {"start", "office:settings"}, {"start", "config:config-item-set", "config:name", "CDATA", "view-settings"}, {"start", "config:config-item-map-indexed", "config:name", "CDATA", "Views"}, {"start", "config:config-item-map-entry"}, {"start", "config:config-item", "config:name", "CDATA", "IsLayerMode", "config:type", "CDATA", "boolean"}, {"chars", "true"}, {"end", "config:config-item"}, {"end", "config:config-item-map-entry"}, {"end", "config:config-item-map-indexed"}, {"end", "config:config-item-set"}, {"end", "office:settings"}, {"end", "office:document-settings"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        final PrintWriter logF = log;
        XModel xDrawModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xDrawDoc);
        XController xController = xDrawModel.getCurrentController();
        final XPropertySet xPropSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xController);
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                try {
                    Boolean value = (Boolean)xPropSet.getPropertyValue("IsLayerMode");
                    logF.println("'IsLayerMode' property value is '" + value + "'");
                    return value == true;
                }
                catch (com.sun.star.uno.Exception e) {
                    logF.println("Exception while checking import :");
                    e.printStackTrace(logF);
                    return false;
                }
            }
        });
        return tEnv;
    }
}

