/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Draw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLMetaImporter
extends TestCase {
    XComponent xDrawDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a drawdocument");
            this.xDrawDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing document ");
        this.xDrawDoc.dispose();
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XInterface oObj = null;
        Object oInt = null;
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            oInt = xMSF.createInstance("com.sun.star.comp.Draw.XMLMetaImporter");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        oObj = (XInterface)oInt;
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", this.xDrawDoc);
        String impTitle = "XMLMetaImporter";
        String[][] xml = new String[][]{{"start", "office:document-meta", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:meta", "CDATA", "http://openoffice.org/2000/meta", "xmlns:dc", "CDATA", "http://purl.org/dc/elements/1.1/"}, {"start", "office:meta"}, {"start", "dc:title"}, {"chars", "XMLMetaImporter"}, {"end", "dc:title"}, {"end", "office:meta"}, {"end", "office:document-meta"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        XDocumentInfoSupplier infoSup = UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)this.xDrawDoc);
        final XPropertySet docInfo = UnoRuntime.queryInterface(XPropertySet.class, (Object)infoSup.getDocumentInfo());
        final PrintWriter logF = log;
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                try {
                    String title = (String)docInfo.getPropertyValue("Title");
                    logF.println("Title returned = '" + title + "'");
                    return "XMLMetaImporter".equals(title);
                }
                catch (com.sun.star.uno.Exception e) {
                    logF.println("Exception occured while checking filter :");
                    e.printStackTrace(logF);
                    return false;
                }
            }
        });
        return tEnv;
    }
}

