/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Draw;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.document.XExporter;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLMetaExporter
extends TestCase {
    XComponent xDrawDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a drawdocument");
            this.xDrawDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        this.xDrawDoc.dispose();
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XInterface oObj = null;
        String TITLE = "XMLMetaExporter";
        FilterChecker filter = new FilterChecker(log);
        Any arg = new Any(new Type(XDocumentHandler.class), (Object)filter);
        try {
            oObj = (XInterface)xMSF.createInstanceWithArguments("com.sun.star.comp.Draw.XMLMetaExporter", new Object[]{arg});
            XExporter xEx = UnoRuntime.queryInterface(XExporter.class, (Object)oObj);
            xEx.setSourceDocument(this.xDrawDoc);
            XDocumentInfoSupplier infoSup = UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)this.xDrawDoc);
            XPropertySet docInfo = UnoRuntime.queryInterface(XPropertySet.class, (Object)infoSup.getDocumentInfo());
            docInfo.setPropertyValue("Title", "XMLMetaExporter");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        filter.addTag(new XMLTools.Tag("office:document-meta"));
        filter.addTagEnclosed(new XMLTools.Tag("office:meta"), new XMLTools.Tag("office:document-meta"));
        filter.addTagEnclosed(new XMLTools.Tag("dc:title"), new XMLTools.Tag("office:meta"));
        filter.addCharactersEnclosed("XMLMetaExporter", new XMLTools.Tag("dc:title"));
        log.println("creating a new environment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"sdraw: StarOffice XML (Draw)"}));
        tEnv.addObjRelation("SourceDocument", this.xDrawDoc);
        tEnv.addObjRelation("XFilter.Checker", filter);
        return tEnv;
    }

    protected class FilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter log) {
            super(log, true);
        }

        @Override
        public boolean checkFilter() {
            return this.check();
        }
    }
}

