/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Draw;

import com.sun.star.container.XNamed;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLContentImporter
extends TestCase {
    XComponent xDrawDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a drawdocument");
            this.xDrawDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing document ");
        this.xDrawDoc.dispose();
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        Object oInt = null;
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            oInt = xMSF.createInstance("com.sun.star.comp.Draw.XMLContentImporter");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        oObj = (XInterface)oInt;
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", this.xDrawDoc);
        String[][] xml = new String[][]{{"start", "office:document", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:draw", "CDATA", "http://openoffice.org/2000/drawing", "office:class", "CDATA", "drawing", "office:version", "CDATA", "1.0"}, {"start", "office:body"}, {"start", "draw:page", "draw:name", "CDATA", "NewSlide1", "draw:master-page-name", "CDATA", "Default"}, {"end", "draw:page"}, {"start", "draw:page", "draw:name", "CDATA", "NewSlide2", "draw:master-page-name", "CDATA", "Default"}, {"end", "draw:page"}, {"end", "draw:page"}, {"end", "office:body"}, {"end", "office:document"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        final PrintWriter fLog = log;
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                int i;
                XDrawPagesSupplier supp = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)XMLContentImporter.this.xDrawDoc);
                XDrawPages xPages = supp.getDrawPages();
                XNamed[] pageArray = new XNamed[xPages.getCount()];
                for (i = 0; i < xPages.getCount(); ++i) {
                    try {
                        pageArray[i] = UnoRuntime.queryInterface(XNamed.class, xPages.getByIndex(i));
                        continue;
                    }
                    catch (com.sun.star.uno.Exception e) {
                        e.printStackTrace(fLog);
                        throw new StatusException("Can't get page name by index.", e);
                    }
                }
                fLog.println("Slide names after import:");
                for (i = 0; i < xPages.getCount(); ++i) {
                    if (!pageArray[i].getName().equals("NewSlide1") && !pageArray[i].getName().equals("NewSlide2")) {
                        fLog.println("Error: some imported values are not exist in target document!");
                        return false;
                    }
                    fLog.println("  " + pageArray[i].getName());
                }
                return true;
            }
        });
        return tEnv;
    }
}

