/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Draw;

import com.sun.star.container.XNamed;
import com.sun.star.document.XExporter;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLContentExporter
extends TestCase {
    XComponent xDrawDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a drawdocument");
            this.xDrawDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        this.xDrawDoc.dispose();
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XInterface oObj = null;
        FilterChecker filter = new FilterChecker(log);
        Any arg = new Any(new Type(XDocumentHandler.class), (Object)filter);
        filter.addTag(new XMLTools.Tag("office:document-content"));
        filter.addTag(new XMLTools.Tag("office:body"));
        filter.addTagEnclosed(new XMLTools.Tag("draw:page"), new XMLTools.Tag("office:body"));
        filter.addTag(new XMLTools.Tag("draw:page", "draw:name", "NewSlide1"));
        filter.addTag(new XMLTools.Tag("draw:page", "draw:name", "NewSlide2"));
        try {
            oObj = (XInterface)xMSF.createInstanceWithArguments("com.sun.star.comp.Draw.XMLContentExporter", new Object[]{arg});
            XExporter xEx = UnoRuntime.queryInterface(XExporter.class, (Object)oObj);
            XDrawPagesSupplier supp = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xDrawDoc);
            XDrawPages set = supp.getDrawPages();
            set.insertNewByIndex(1);
            XDrawPage page1 = UnoRuntime.queryInterface(XDrawPage.class, set.getByIndex(0));
            XNamed NPage1 = UnoRuntime.queryInterface(XNamed.class, (Object)page1);
            NPage1.setName("NewSlide1");
            XDrawPage page2 = UnoRuntime.queryInterface(XDrawPage.class, set.getByIndex(1));
            XNamed NPage2 = UnoRuntime.queryInterface(XNamed.class, (Object)page2);
            NPage2.setName("NewSlide2");
            xEx.setSourceDocument(this.xDrawDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        log.println("creating a new environment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"sdraw: StarOffice XML (Draw)"}));
        tEnv.addObjRelation("SourceDocument", this.xDrawDoc);
        tEnv.addObjRelation("XFilter.Checker", filter);
        return tEnv;
    }

    protected class FilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter log) {
            super(log, true);
        }

        @Override
        public boolean checkFilter() {
            return this.check();
        }
    }
}

