/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Chart;

import com.sun.star.beans.XPropertySet;
import com.sun.star.chart.XChartDocument;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class XMLImporter
extends TestCase {
    XComponent comp;
    XChartDocument xChartDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a chartdocument");
            this.xChartDoc = SOF.createChartDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        this.comp = this.xChartDoc;
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing document ");
        this.comp.dispose();
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XPropertySet xTitleProp;
        XInterface oObj = null;
        Object oInt = null;
        String impValue = "XMLImporter_test";
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            oInt = xMSF.createInstance("com.sun.star.comp.Chart.XMLImporter");
            XShape oTitle = this.xChartDoc.getTitle();
            xTitleProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)oTitle);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        oObj = (XInterface)oInt;
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", this.comp);
        String[][] xml = new String[][]{{"start", "office:document", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:text", "CDATA", "http://openoffice.org/2000/text", "xmlns:chart", "CDATA", "http://openoffice.org/2000/chart", "xmlns:table", "CDATA", "http://openoffice.org/2000/table", "xmlns:svg", "CDATA", "http://openoffice.org/2000/svg", "office:class", "CDATA", "chart", "office:version", "CDATA", "1.0"}, {"start", "office:body"}, {"start", "chart:chart"}, {"start", "chart:title"}, {"start", "text:p"}, {"chars", "XMLImporter_test"}, {"end", "text:p"}, {"end", "chart:title"}, {"end", "chart:chart"}, {"end", "office:body"}, {"end", "office:document-content"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        final PrintWriter logF = log;
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                try {
                    String title = (String)xTitleProp.getPropertyValue("String");
                    logF.println("Title returned = '" + title + "'");
                    return "XMLImporter_test".equals(title);
                }
                catch (com.sun.star.uno.Exception e) {
                    logF.println("Exception occured while checking filter :");
                    e.printStackTrace(logF);
                    return false;
                }
            }
        });
        return tEnv;
    }
}

