/*
 * Decompiled with CFR 0.152.
 */
package mod._xmloff.Chart;

import com.sun.star.beans.XPropertySet;
import com.sun.star.chart.XChartDocument;
import com.sun.star.document.XExporter;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.XMLTools;
import util.utils;

public class XMLExporter
extends TestCase {
    XChartDocument xChartDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a chartdocument");
            this.xChartDoc = SOF.createChartDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    close xChartDoc ");
        DesktopTools.closeDoc(this.xChartDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XInterface oObj = null;
        String exportStr = "XMLExporter test.";
        FilterChecker filter = new FilterChecker(log);
        Any arg = new Any(new Type(XDocumentHandler.class), (Object)filter);
        try {
            oObj = (XInterface)xMSF.createInstanceWithArguments("com.sun.star.comp.Chart.XMLExporter", new Object[]{arg});
            XExporter xEx = UnoRuntime.queryInterface(XExporter.class, (Object)oObj);
            xEx.setSourceDocument(this.xChartDoc);
            XShape oTitle = this.xChartDoc.getTitle();
            XPropertySet xTitleProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)oTitle);
            xTitleProp.setPropertyValue("String", "XMLExporter test.");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        filter.addTag(new XMLTools.Tag("office:document"));
        filter.addTagEnclosed(new XMLTools.Tag("office:meta"), new XMLTools.Tag("office:document"));
        filter.addTagEnclosed(new XMLTools.Tag("office:body"), new XMLTools.Tag("office:document"));
        filter.addCharactersEnclosed("XMLExporter test.", new XMLTools.Tag("chart:title"));
        log.println("creating a new environment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"schart: StarOffice XML (Chart)"}));
        tEnv.addObjRelation("SourceDocument", this.xChartDoc);
        tEnv.addObjRelation("XFilter.Checker", filter);
        log.println("Implementation Name: " + utils.getImplName(oObj));
        return tEnv;
    }

    protected class FilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter log) {
            super(log, true);
        }

        @Override
        public boolean checkFilter() {
            return this.check();
        }
    }
}

