/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.tree.XMutableTreeDataModel;
import com.sun.star.awt.tree.XMutableTreeNode;
import com.sun.star.awt.tree.XTreeControl;
import com.sun.star.awt.tree.XTreeNode;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.SelectionType;
import java.io.PrintWriter;
import java.util.Comparator;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.UITools;
import util.utils;

public class UnoTreeControl
extends TestCase {
    private static XTextDocument xTextDoc;
    private static XMutableTreeDataModel mXTreeDataModel;
    private static XMultiServiceFactory mxMSF;
    private static PrintWriter log;
    private static boolean debug;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        UnoTreeControl.log = log;
        debug = Param.getBool("DebugIsActive");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a textdocument");
            xTextDoc = SOF.createTextDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        String sTreeControlName = "UnoTreeControl-Test";
        mxMSF = (XMultiServiceFactory)Param.getMSF();
        XTreeControl oObj = null;
        XMutableTreeNode xNode = null;
        try {
            mXTreeDataModel = UnoRuntime.queryInterface(XMutableTreeDataModel.class, mxMSF.createInstance("com.sun.star.awt.tree.MutableTreeDataModel"));
            xNode = mXTreeDataModel.createNode("UnoTreeControl", false);
            xNode.setDataValue("UnoTreeControl");
            xNode.setExpandedGraphicURL("private:graphicrepository/sd/res/triangle_down.png");
            xNode.setCollapsedGraphicURL("private:graphicrepository/sd/res/triangle_right.png");
            this.fillNode(xNode);
            mXTreeDataModel.setRoot(xNode);
            XControlModel xDialogModel = UnoRuntime.queryInterface(XControlModel.class, mxMSF.createInstance("com.sun.star.awt.UnoControlDialogModel"));
            XPropertySet xDialogPropertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xDialogModel);
            xDialogPropertySet.setPropertyValue("PositionX", new Integer(50));
            xDialogPropertySet.setPropertyValue("PositionY", new Integer(50));
            xDialogPropertySet.setPropertyValue("Width", new Integer(256));
            xDialogPropertySet.setPropertyValue("Height", new Integer(256));
            xDialogPropertySet.setPropertyValue("Title", "Tree Control Test");
            XMultiServiceFactory xDialogMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xDialogModel);
            XControlModel xTreeControlModel = UnoRuntime.queryInterface(XControlModel.class, xDialogMSF.createInstance("com.sun.star.awt.tree.TreeControlModel"));
            XPropertySet XTreeControlModelSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xTreeControlModel);
            XTreeControlModelSet.setPropertyValue("SelectionType", SelectionType.NONE);
            XTreeControlModelSet.setPropertyValue("PositionX", new Integer(3));
            XTreeControlModelSet.setPropertyValue("PositionY", new Integer(3));
            XTreeControlModelSet.setPropertyValue("Width", new Integer(253));
            XTreeControlModelSet.setPropertyValue("Height", new Integer(253));
            XTreeControlModelSet.setPropertyValue("DataModel", mXTreeDataModel);
            XTreeControlModelSet.setPropertyValue("ShowsRootHandles", new Boolean(false));
            XTreeControlModelSet.setPropertyValue("ShowsHandles", new Boolean(false));
            XTreeControlModelSet.setPropertyValue("RootDisplayed", new Boolean(true));
            XTreeControlModelSet.setPropertyValue("Editable", new Boolean(true));
            XNameContainer xDialogModelContainer = UnoRuntime.queryInterface(XNameContainer.class, (Object)xDialogModel);
            xDialogModelContainer.insertByName(sTreeControlName, xTreeControlModel);
            XControl xDialogControl = UnoRuntime.queryInterface(XControl.class, mxMSF.createInstance("com.sun.star.awt.UnoControlDialog"));
            xDialogControl.setModel(xDialogModel);
            XToolkit xToolkit = UnoRuntime.queryInterface(XToolkit.class, mxMSF.createInstance("com.sun.star.awt.Toolkit"));
            xDialogControl.createPeer(xToolkit, null);
            XControlContainer xDialogContainer = UnoRuntime.queryInterface(XControlContainer.class, (Object)xDialogControl);
            XTreeControl xTreeControl = UnoRuntime.queryInterface(XTreeControl.class, (Object)xDialogContainer.getControl(sTreeControlName));
            xTreeControl.expandNode(xNode);
            oObj = xTreeControl;
            XDialog xDialog = UnoRuntime.queryInterface(XDialog.class, (Object)xDialogControl);
            execurteDialog aDialog = new execurteDialog(xDialog);
            aDialog.start();
        }
        catch (com.sun.star.uno.Exception ex) {
            ex.printStackTrace();
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("XTreeControl_Node", xNode);
        try {
            System.out.println("count of children: " + xNode.getChildCount());
            tEnv.addObjRelation("Selections", new Object[]{xNode.getChildAt(0), xNode});
        }
        catch (IndexOutOfBoundsException ex) {
            log.println("ERROR: could not add object relation 'Selections' because 'xNode.getChildAt(1) failed: " + ex.toString());
        }
        tEnv.addObjRelation("Comparer", new Comparator(){

            public int compare(Object o1, Object o2) {
                XMutableTreeNode xNode1 = UnoRuntime.queryInterface(XMutableTreeNode.class, o1);
                XTreeNode xNode2a = null;
                try {
                    xNode2a = (XTreeNode)AnyConverter.toObject((Type)new Type(XTreeNode.class), (Object)o2);
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
                XMutableTreeNode xNode2 = UnoRuntime.queryInterface(XMutableTreeNode.class, xNode2a);
                if (((String)xNode1.getDataValue()).equals((String)xNode2.getDataValue())) {
                    return 0;
                }
                return -1;
            }
        });
        System.out.println("ImplementationName: " + utils.getImplName(oObj));
        return tEnv;
    }

    private void fillNode(XMutableTreeNode xNode) {
        if (xNode.getChildCount() == 0) {
            String sParentPath = (String)xNode.getDataValue();
            String officeUserPath = utils.getOfficeUserPath(mxMSF);
            Object fileacc = null;
            try {
                fileacc = mxMSF.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
            }
            catch (com.sun.star.uno.Exception ex) {
                ex.printStackTrace();
            }
            XSimpleFileAccess sA = UnoRuntime.queryInterface(XSimpleFileAccess.class, fileacc);
            this.dirlist(officeUserPath, xNode);
        }
    }

    private void dirlist(String dir, XMutableTreeNode xNode) {
        Object fileacc = null;
        try {
            fileacc = mxMSF.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
        }
        catch (com.sun.star.uno.Exception ex) {
            ex.printStackTrace();
        }
        XSimpleFileAccess sfa = UnoRuntime.queryInterface(XSimpleFileAccess.class, fileacc);
        XMutableTreeNode xChildNode = null;
        try {
            xChildNode = mXTreeDataModel.createNode(dir.substring(dir.lastIndexOf("/") + 1, dir.length()), sfa.isFolder(dir));
            xChildNode.setDataValue(dir);
            boolean test = sfa.isFolder(dir);
            if (sfa.isFolder(dir)) {
                xChildNode.setExpandedGraphicURL("private:graphicrepository/sd/res/triangle_down.png");
                xChildNode.setCollapsedGraphicURL("private:graphicrepository/sd/res/triangle_right.png");
                String[] children = sfa.getFolderContents(dir, true);
                if (children != null) {
                    for (int i = 0; i < children.length; ++i) {
                        String filename = children[i];
                        this.dirlist(filename, xChildNode);
                    }
                }
            } else {
                xChildNode.setNodeGraphicURL("private:graphicrepository/sw/imglst/nc20010.png");
            }
        }
        catch (CommandAbortedException ex) {
            ex.printStackTrace();
        }
        catch (com.sun.star.uno.Exception ex) {
            ex.printStackTrace();
        }
        try {
            xNode.appendChild(xChildNode);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    private XAccessibleContext getAccessibleContext(XMutableTreeNode xNode) {
        UITools oDocUITools = new UITools(mxMSF, xTextDoc);
        XWindow xDialogWindow = null;
        try {
            xDialogWindow = oDocUITools.getActiveTopWindow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        UITools oDialog = new UITools(mxMSF, xDialogWindow);
        oDialog.printAccessibleTree(log, debug);
        return null;
    }

    static {
        debug = false;
    }

    private class execurteDialog
    extends Thread {
        private XDialog mXDialog;

        public execurteDialog(XDialog xDialog) {
            this.mXDialog = xDialog;
        }

        @Override
        public void run() {
            this.mXDialog.endExecute();
        }
    }
}

