/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDevice;
import com.sun.star.awt.XGraphics;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XControlAccess;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.SOfficeFactory;
import util.WriterTools;
import util.utils;

public class UnoScrollBarControl
extends TestCase {
    private static XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a textdocument");
            xTextDoc = SOF.createTextDoc(null);
            log.println("maximize the window size");
            XModel xModel = UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
            XFrame xFrame = xModel.getCurrentController().getFrame();
            XWindow xWin = xFrame.getContainerWindow();
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension dim = tk.getScreenSize();
            Rectangle newPosSize = xWin.getPosSize();
            newPosSize.Width = new Double(dim.getWidth()).intValue();
            newPosSize.Height = new Double(dim.getHeight()).intValue();
            newPosSize.X = 0;
            newPosSize.Y = 0;
            xWin.setPosSize(newPosSize.X, newPosSize.Y, newPosSize.Width, newPosSize.Height, (short)15);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(xTextDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XControl oObj = null;
        XWindowPeer the_win = null;
        XToolkit the_kit = null;
        XDevice aDevice = null;
        XGraphics aGraphic = null;
        XControl aControl = null;
        XControlShape aShape = FormTools.createUnoControlShape(xTextDoc, 3000, 4500, 15000, 10000, "ScrollBar", "UnoControlScrollBar");
        WriterTools.getDrawPage(xTextDoc).add(aShape);
        XControlModel the_Model = aShape.getControl();
        XControlShape aShape2 = FormTools.createControlShape(xTextDoc, 3000, 4500, 5000, 10000, "TextField");
        WriterTools.getDrawPage(xTextDoc).add(aShape2);
        XControlModel the_Model2 = aShape2.getControl();
        XControlAccess the_access = UnoRuntime.queryInterface(XControlAccess.class, (Object)xTextDoc.getCurrentController());
        try {
            oObj = the_access.getControl(the_Model);
            aControl = the_access.getControl(the_Model2);
            the_win = the_access.getControl(the_Model).getPeer();
            the_kit = the_win.getToolkit();
            aDevice = the_kit.createScreenCompatibleDevice(200, 200);
            aGraphic = aDevice.createGraphics();
        }
        catch (Exception e) {
            log.println("Couldn't get ScrollBarControl");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get ScrollBarControl", e);
        }
        log.println("creating a new environment for UnoControlScrollBar object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("Document", xTextDoc);
        tEnv.addObjRelation("GRAPHICS", aGraphic);
        tEnv.addObjRelation("CONTEXT", xTextDoc);
        tEnv.addObjRelation("WINPEER", the_win);
        tEnv.addObjRelation("TOOLKIT", the_kit);
        tEnv.addObjRelation("MODEL", the_Model);
        XWindow forObjRel = UnoRuntime.queryInterface(XWindow.class, (Object)aControl);
        tEnv.addObjRelation("XWindow.AnotherWindow", forObjRel);
        System.out.println("ImplementationName: " + utils.getImplName(oObj));
        return tEnv;
    }
}

