/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.awt.XCheckBox;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDevice;
import com.sun.star.awt.XGraphics;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XControlAccess;
import ifc.awt._XItemListener;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.SOfficeFactory;
import util.WriterTools;
import util.utils;

public class UnoControlCheckBox
extends TestCase {
    private static XTextDocument xTextDoc;
    private static XTextDocument xTD2;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a textdocument");
            xTextDoc = SOF.createTextDoc(null);
            xTD2 = WriterTools.createTextDoc((XMultiServiceFactory)Param.getMSF());
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(xTextDoc);
        DesktopTools.closeDoc(xTD2);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XControl oObj = null;
        XWindowPeer the_win = null;
        XToolkit the_kit = null;
        XDevice aDevice = null;
        XGraphics aGraphic = null;
        XWindow anotherWindow = null;
        XControlShape aShape = FormTools.createUnoControlShape(xTextDoc, 3000, 4500, 15000, 10000, "CheckBox", "UnoControlCheckBox");
        WriterTools.getDrawPage(xTextDoc).add(aShape);
        XControlModel the_Model = aShape.getControl();
        XControlAccess the_access = UnoRuntime.queryInterface(XControlAccess.class, (Object)xTextDoc.getCurrentController());
        try {
            oObj = the_access.getControl(the_Model);
            the_win = the_access.getControl(the_Model).getPeer();
            the_kit = the_win.getToolkit();
            aDevice = the_kit.createScreenCompatibleDevice(200, 200);
            aGraphic = aDevice.createGraphics();
        }
        catch (Exception e) {
            log.println("Couldn't get CheckBoxControl");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get CheckBoxControl", e);
        }
        log.println("creating a new environment for UnoControlCheckBox object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("GRAPHICS", aGraphic);
        tEnv.addObjRelation("CONTEXT", xTextDoc);
        tEnv.addObjRelation("WINPEER", the_win);
        tEnv.addObjRelation("TOOLKIT", the_kit);
        tEnv.addObjRelation("MODEL", the_Model);
        _XItemListener.TestItemListener listener = new _XItemListener.TestItemListener();
        XCheckBox check = UnoRuntime.queryInterface(XCheckBox.class, (Object)oObj);
        check.addItemListener(listener);
        tEnv.addObjRelation("TestItemListener", listener);
        System.out.println("ImplementationName: " + utils.getImplName(oObj));
        try {
            XController aController = xTD2.getCurrentController();
            XFrame aFrame = aController.getFrame();
            anotherWindow = aFrame.getComponentWindow();
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create XWindow", e);
        }
        tEnv.addObjRelation("XWindow.AnotherWindow", anotherWindow);
        return tEnv;
    }
}

