/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XControlAccess;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.SOfficeFactory;
import util.WriterTools;
import util.utils;

public class Toolkit
extends TestCase {
    private static XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a textdocument");
            xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(xTextDoc);
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        XWindowPeer the_win = null;
        XWindow win = null;
        XControlShape aShape = FormTools.createControlShape(xTextDoc, 3000, 4500, 15000, 10000, "CommandButton");
        WriterTools.getDrawPage(xTextDoc).add(aShape);
        XControlModel the_Model = aShape.getControl();
        XControlAccess the_access = UnoRuntime.queryInterface(XControlAccess.class, (Object)xTextDoc.getCurrentController());
        XController cntrlr = UnoRuntime.queryInterface(XController.class, (Object)xTextDoc.getCurrentController());
        try {
            win = cntrlr.getFrame().getContainerWindow();
            the_win = the_access.getControl(the_Model).getPeer();
            oObj = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XModel xModel = UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        log.println("    creating a new environment for toolkit object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("Implementation Name: " + utils.getImplName(oObj));
        tEnv.addObjRelation("WINPEER", the_win);
        tEnv.addObjRelation("XModel", xModel);
        tEnv.addObjRelation("XDataTransferProviderAccess.XWindow", win);
        return tEnv;
    }
}

