/*
 * Decompiled with CFR 0.152.
 */
package mod._toolkit;

import com.sun.star.drawing.XControlShape;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.WriterTools;
import util.utils;

public class TabControllerModel
extends TestCase {
    private static XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters param, PrintWriter log) {
        try {
            log.println("creating a textdocument");
            xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)param.getMSF());
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters param, PrintWriter log) {
        log.println("disposing xTextDoc");
        DesktopTools.closeDoc(xTextDoc);
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters param, PrintWriter log) {
        XInterface oObj = null;
        log.println("inserting some ControlShapes");
        XControlShape shape1 = FormTools.createControlShape(xTextDoc, 3000, 4500, 15000, 1000, "CommandButton");
        XControlShape shape2 = FormTools.createControlShape(xTextDoc, 5000, 3500, 7500, 5000, "TextField");
        try {
            oObj = (XInterface)((XMultiServiceFactory)param.getMSF()).createInstance("com.sun.star.awt.TabControllerModel");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create TabControllerModel", e);
        }
        log.println("creating a new environment for TabControllerModel");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("OBJNAME", "stardiv.vcl.controlmodel.TabController");
        tEnv.addObjRelation("Model1", shape1.getControl());
        tEnv.addObjRelation("Model2", shape2.getControl());
        tEnv.addObjRelation("noPS", new Boolean(true));
        System.out.println("ImplementationName: " + utils.getImplName(oObj));
        return tEnv;
    }
}

